#ifndef STR_H
#ifndef PARAMS
#include "params.h"
#endif

/*
 * string package with heap management
 * (death to fixed length arrays)
 */

struct string {
    char *base;			/* base of string */
    char *cur;			/* current end of the string */
    char *end;			/* end of the allocated space */
    int a0;			/* fibonacci allocator vars */
    int a1;
};

/*
 * macros for string access
 */

#define STR_APPEND(s,c) \
    do {if ((s)->cur<(s)->end) *(s)->cur++=(c);else str_append((s),(c));} while(0)
#define STR_LENGTH(s) ((s)->cur - (s)->base)

void str_zero PARAMS((struct string *));
void str_init PARAMS((struct string *));
void str_free PARAMS((struct string *));
void str_append PARAMS((struct string *, int));

#if defined(HAVE_STDARG_H) && defined(__STDC__)
void str_concat PARAMS((struct string *, ...));
#else
void str_concat ();
#endif

#define STR_H
#endif

