/*
 * very crude package to implement variable-length strings.
 * this is used even though it's crude because fixed-length buffers
 * often create a security risk.
 */

#include "conf.h"

#include <stdio.h>

#ifdef STDC_HEADERS
#include <memory.h>
#include <stdlib.h>
#include <string.h>
#else
char *malloc ();
char *realloc ();
#endif

#if defined(HAVE_STDARG_H) && defined(__STDC__)
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include "str.h"


/*
 * set 's' to the null string; also used to initialize strings.
 */

void
str_zero (s)
struct string *s;
{
    if (s->base == NULL) {
	int size;

	s->a0 = s->a1 = 1;
	s->cur = s->base = malloc (1); /* XXX what if this fails? */
	s->end = s->cur + 1;
    }
    else
	s->cur = s->base;
}

/*
 * initialize a brand-new string
 */

void
str_init (s)
struct string *s;
{
    memset ((char *) s, 0, sizeof (*s));
    str_zero (s);
}

/*
 * free the heap space associated with 's'
 */

void
str_free (s)
struct string *s;
{
    if (s->base) {
	free (s->base);
	s->base = s->cur = s->end = NULL;
    }
}

/*
 * append character 'c' to 's', allocating more space if necessary
 * does not ensure that there is a NUL following the string;
 * you have to do that yourself
 */

void
str_append (s, c)
struct string *s;
int c;
{
    if (s->cur >= s->end) {
	int newsize = s->a0 + s->a1;
	char *newbase = realloc (s->base, newsize);
				/* XXX what if this fails? */

	s->a0 = s->a1;
	s->a1 = newsize;
	s->cur = newbase + (s->cur - s->base);
	s->end = newbase + newsize;
	s->base = newbase;
    }
    *s->cur++ = c;
}

/*
 * concatenate several NUL-terminated strings together onto 's'
 * leave a trailing NUL at the end of 's' so that s->base is
 * also a valid NUL-terminated string
 */

#if defined(HAVE_STDARG_H) && defined(__STDC__)
void
str_concat (struct string *s, ...)
{
    va_list ap;
    char *str;
    int length;

    length = 1;
    va_start (ap, s);
    while (str = va_arg (ap, char *)) {
	length += strlen (str);
    }
    if (length > (s->end - s->base)) {
	char *newbase = realloc (s->base, length);
	s->a0 = length/2;
	s->a1 = length;
	s->cur = newbase + (s->cur - s->base);
	s->end = newbase + length;
	s->base = newbase;
    }
    va_start (ap, s);
    while (str = va_arg (ap, char *)) {
	while (*str)
	    *s->cur++ = *str++;
    }
    *s->cur++ = 0;
}
#else
void
str_concat (va_alist)
va_dcl
{
    va_list ap;
    char *str;
    int length;
    struct string *s;

    length = 1;
    va_start (ap);
    s = va_arg (ap, struct string *);
    while (str = va_arg (ap, char *)) {
	length += strlen (str);
    }
    if (length > (s->end - s->base)) {
	char *newbase = realloc (s->base, length);
	s->a0 = length/2;
	s->a1 = length;
	s->cur = newbase + (s->cur - s->base);
	s->end = newbase + length;
	s->base = newbase;
    }
    va_start (ap);
    s = va_arg (ap, struct string *);
    while (str = va_arg (ap, char *)) {
	while (*str)
	    *s->cur++ = *str++;
    }
    *s->cur++ = 0;
}
#endif

