#include <stdio.h>
#include <stdlib.h>
#include "conf.h"

#ifndef HAVE_SETENV
extern char **environ;

int
setenv (char *name, char *value, int overwrite)
{
    int i, j;
    int found;
    int nl;
    char **new_environ;
    char *new_slot;

    if (name == NULL)
	return -1;

    nl = strlen (name);

    /* 
     * allocate enough memory for a new environ[] 
     * which might be one slot larger (or smaller) than we have now
     */
    for (i = 0; environ[i]; ++i);
    new_environ = (char **) malloc ((i + 2) * sizeof (char *));
    if (new_environ == NULL)
	return -1;

    /* copy environ, looking for the variable we want to set */
    j = 0;
    found = 0;
    for (i = 0; environ[i]; ++i) {
	if (strncmp (environ[i], name, nl) == 0 && environ[i][nl] == '=') {
	    /* found it */
	    if (overwrite) {
		if (value == NULL) 	/* don't copy this variable */
		    ;
		else {			/* do replace this variable */
		    char *newval = malloc (strlen (name) + strlen (value) + 2);

		    if (newval == NULL)
			return -1;
		    strcpy (newval, name);
		    strcat (newval, "=");
		    strcat (newval, value);
		    new_environ[j++] = newval;
		}
		found = 1;
	    }
	    else {
		/* 
		 * since this variable is already present, and overwrite 
		 * wasn't set, return without changing anything 
		 */
		free (new_environ);
		return 0;
	    }
	}
	else 
	    new_environ[j++] = environ[i];
    }
    /*
     * if not found in the list, append this new variable to the list 
     */
    if (!found) {
	char *newval = malloc (strlen (name) + strlen (value) + 2);

        if (newval == NULL)
	    return -1;
	strcpy (newval, name);
	strcat (newval, "=");
	strcat (newval, value);
	new_environ[j++] = newval;
    }
    new_environ[j++] = NULL;
    environ = new_environ;
    return 0;
}
#endif

#ifdef TEST
main (int argc, char **argv)
{
    int i;
    int x;

    printf ("before:\n");
    for (i = 0; environ[i]; ++i)
	printf ("%s\n", environ[i]);

    x = setenv (argv[1], argv[2], atoi(argv[3]));
    printf ("setenv (\"%s\", \"%s\", %d) returns %d\n",
		argv[1], argv[2], atoi(argv[3]), x);
    printf ("after:\n");
    for (i = 0; environ[i]; ++i)
        printf ("%s\n", environ[i]);
}
#endif

/*
 * this is an attempt to keep gcc on alpha from barfing
 * when we link in setenv.o  and HAVE_SETENV is undefined.
 */

int
setenv_frob ()
{
    return 0;
}
