#include "conf.h"

#ifdef HAVE_LIBGEN_H
#include <libgen.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "basename.h"
#include "concat.h"
#include "pathnames.h"
#include "result.h"
#include "str.h"

/*
 * unpack a .tgz file
 *
 * XXX really should do this internally, rather than calling a
 * shell script, for better security and better error handling.  
 */

static int 
unpack_and_verify_tgz (struct result *x, char *dir, char *package_fn)
{
    char *command;
    int status;

#if 0
    fprintf (stderr, "unpack_and_verify_tgz (x, %s, %s)\n",
	     dir, package_fn);
#endif

#ifdef HAVE_ASPRINTF
    asprintf (&command, "PATH=\"%s:$PATH\" %s \"%s\" \"%s\"", 
	      NETBUILD_BIN_DIR, PATH_UNPACK_TGZ, dir, package_fn);
#else
    command = concat ("PATH=\"", NETBUILD_BIN_DIR, ":$PATH\" ",
		      PATH_UNPACK_TGZ, " \"", dir, "\" \"",
		      package_fn, "\"", NULL);
#endif
    status = system (command);

#if 0
    fprintf (stderr, "exit status %d\n", WEXITSTATUS(status));
#endif

    if (status == 0)
	return success (x);
    else if (status == 127)
	return failure (x, 1, "unpack_tgz: could not unpack %s, %s",
			package_fn, "could not exec shell");
    else
	return failure (x, 1, "unpack_tgz.sh returned status %d",
			WEXITSTATUS(status));
}


/*
 * remove a directory and its descendants
 */

int
rmtree (char *dir)
{
    char *command;

#if 0
    fprintf (stderr, "[removing %s]\n", dir);
#endif

    command = concat ("rm -rf '", dir, "'", NULL);
    system (command);
    if (access (dir, F_OK) == 0)
	return -1;
    return 0;
}

/*
 * unpack a package from 'package_fn' to directory 'dir'
 */

int
unpack_and_verify_package (struct result *x, char *dir, char *package_fn)
{
    char *bn;
    char *suffix;

#if 0
    fprintf (stderr, "unpack_and_verify_package (x, %s, %s)\n",
	     dir, package_fn);
#endif

    bn = basename (package_fn);
    suffix = strrchr (bn, '.');
    if (suffix == NULL)
	suffix = "";

#if 0
    fprintf (stderr, "suffix=%s\n", suffix);
#endif

    rmtree (dir);
    mkdir_recursive (dir, 0700);

    if (strcasecmp (suffix, ".tgz") == 0)
	return unpack_and_verify_tgz (x, dir, package_fn);
    else
	return failure (x, 1, "unpack_package: %s: unknown package format\n",
			package_fn);
}

