#include <stdio.h>
#include <sys/types.h>
#include <sys/systemcfg.h>

main ()
{
    char *foo;

    switch (_system_configuration.architecture) {
	case POWER_RS: foo="power"; break;
	case POWER_PC: foo="powerpc"; break;
	case IA64: foo="ia64"; break;
	default: foo="unknown"; break;
    }
    printf ("target.cpu.arch = %s\n", foo);
    switch (_system_configuration.implementation) {
	case POWER_RS1: foo="rs1"; break;
	case POWER_RSC:	foo="rsc"; break;
	case POWER_RS2: foo="rs2"; break;
	case POWER_601: foo="ppc601"; break;
	case POWER_603: foo="ppc603"; break;
	case POWER_604: foo="ppc604"; break;
	case POWER_620: foo="ppc620"; break;
	case POWER_630: foo="ppc630"; break;
	case POWER_A35: foo="ppca35"; break;
	case POWER_RS64II: foo="rs64-ii"; break;
	case POWER_RS64III: foo="rs64-iii"; break;
	case POWER_RS64IV: foo="power4"; break;
	case POWER_MPC7450: foo="mpc7450"; break;
	default: foo="unknown"; break;
    }
    printf ("target.cpu.implementation = %s\n", foo);
    switch (_system_configuration.version) {
	case PV_601:	foo="ppc601"; break;
	case PV_601a:	foo="ppc601a"; break;
	case PV_603:	foo="ppc603"; break;
	case PV_604:	foo="ppc604"; break;
	case PV_620:	foo="ppc620"; break;
	case PV_630:	foo="ppc630"; break;
	case PV_A35:	foo="ppca35"; break;
	case PV_RS64II:	foo="ppcrs64ii"; break;
	case PV_RS64III: foo="ppcrs64iii"; break;
	case PV_4:	foo="ppc4"; break;
	case PV_MPC7450: foo="ppc7450"; break;
	case PV_4_2:	foo="ppc4_2"; break;
	case PV_RS2:	foo="rs2"; break;
	case PV_RS1:	foo="rs1"; break;
	case PV_RSC:	foo="rsc"; break;
	case PV_M1:	foo="ia64-m1"; break;
	case PV_M2:	foo="ia64-m2"; break;
    }
    printf ("target.cpu.version = %s\n", foo);
    printf ("target.ncpu = %d\n", _system_configuration.ncpus);
}
