#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "nvpl.h"

/*
 * create a new (empty) name-value pair list
 */

struct nvpl *
new_nvpl ()
{
    struct nvpl *nvpl = (struct nvpl *) malloc_or_else (sizeof (struct nvpl));

    memset (nvpl, 0, sizeof (struct nvpl));
    return nvpl;
}

/*
 * create a new name-value pair
 *
 * NOTE: 'name' and 'value' MUST be in stable storage!
 * (meaning the caller may need to strdup () them )
 */

struct nvpl *
nvp (char *name, char *value)
{
    struct nvpl *nvpl = new_nvpl ();

    nvpl->name = name;
    nvpl->value = value;
    nvpl->next = NULL;
    return nvpl;
}

/*
 * add a name-value pair to the list 'nvpl'.
 * return a pointer to the new name-value pair list
 *
 * NOTE:  'name' and 'value' MUST be in stable storage!
 * (meaning the caller may need to strdup () them )
 */

struct nvpl *
add_nvp (struct nvpl *nvpl, char *name, char *value)
{
    struct nvpl *new_nvp = nvp (name, value);

    new_nvp->next = nvpl;
    return new_nvp;
}

/*
 * create a list of name-value pairs using 'ap'
 */

struct nvpl *
make_nvpl_va (va_list ap)
{
    struct nvpl *nvpl = NULL;
    struct nvpl *new_nvp;
    char *name;
    char *value;

    while (name = va_arg (ap, char *)) {
	value = va_arg (ap, char *);
#if 0
	fprintf (stderr, "adding %s=%s\n", name, value);
#endif
	new_nvp = nvp (name, value);
	new_nvp->next = nvpl;
	nvpl = new_nvp;
    }
    return nvpl;
}


struct nvpl *
find_nvp (struct nvpl *nvpl, char *name)
{
    while (nvpl != NULL) {
	if (nvpl->name && strcmp (nvpl->name, name) == 0)
	    return nvpl;
	nvpl = nvpl->next;
    }
    return NULL;
}

char *
find_value (struct nvpl *nvpl, char *name)
{
    struct nvpl *it = find_nvp (nvpl, name);

    if (it == NULL || it->value == NULL)
	return NULL;
    return it->value;
}

void
print_nvpl (FILE *fp, struct nvpl *nvpl)
{
    while (nvpl) {
	fprintf (fp, "%s=\"%s\"\n", nvpl->name, nvpl->value);
	nvpl = nvpl->next;
    }
}
