#include <stdio.h>
#include "pathnames.h"

extern int verbosity;

/*
 * return a string representing the target platform
 *
 * method - call the GNU config.guess script and return the 
 * output string.
 *
 * XXX 
 * by now this should no longer be used for target-to-library
 * matching, but we're keeping it around in case it's needed
 * to gateway with any tool that uses the gnu strings.
 */

char *
get_gnu_arch ()
{
    static char myarch[1024] = { '\0' };
    FILE *fp;

    if (*myarch)
	return myarch;

    fp = popen (PATH_CONFIG_GUESS, "r");
    if (fp == NULL)
	goto fail;

    /* XXX potential buffer overflow */
    if (fscanf (fp, "%s", myarch) != 1)
	goto fail;

    pclose (fp);
    if (verbosity > 0)
	fprintf (stderr, "nb: gnu arch = %s\n", myarch);
    return myarch;

 fail:
    fprintf (stderr, "nb: cannot get gnu arch\n");
    exit (1);
}
