/*
 * routines to read and parse RFC822-style header fields
 *
 * error reporting: function return values
 * error messages: none
 *
 * dependencies: none
 *
 * todo:
 */

#include "conf.h"

#include <stdio.h>
#include <ctype.h>
#ifdef STDC_HEADERS
#include <string.h>
#else
char *strchr ();
#endif
#include "field.h"

/*
 * given a field, return a NUL-terminated pointer to the field name
 * (in a static buffer)
 */

unsigned char *
field_name (buf)
unsigned char *buf;
{
    static unsigned char foo[100];
    unsigned char *dst = foo;
    
    while (*buf && *buf != ':' && !isspace (*buf))
	if (dst < foo + sizeof(foo) - 1)
	    *dst++ = *buf++;
    *dst++ = 0;
    return foo;
}

/*
 * given a field, return a pointer to the field body
 */

unsigned char *
field_body (field)
unsigned char *field;
{
    unsigned char *colon;

    if (field == NULL)
	return NULL;
    colon = (unsigned char *) strchr ((char *) field, ':');
    if (colon == NULL)
	return NULL;
    return colon + 1;
}

/*
 * return 1 iff 's' is a header field with name 'name'
 */

int
match_field_name (name, s)
char *name;
unsigned char *s;
{
    int nl = strlen (name);

    if (strncasecmp ((char *) s, name, nl) == 0) {
	s += nl;
	while (*s == ' ' || *s == '\t' || *s == '\r' || *s == '\n')
	    ++s;
	return (*s == ':');
    }
    return 0;
}

/*
 * read in a header field, including continuation lines
 */

unsigned char *
get_header_field (buf, size, fp)
unsigned char *buf;
int size;
FILE *fp;
{
    unsigned char *d = buf;
    int c;
    int bol = 1;

    while ((c = getc (fp)) != EOF) {
	/*
	 * if we're at the beginning of a line, and the buffer
	 * is empty (we're not at the start of a header),
	 * and the first character of the line is NOT a SPACE
	 * or HTAB, this is a new field.  So put the character
	 * back on the input stream and return.
	 */
	if (bol && (d - buf) > 0 && c != ' ' && c != '\t') {
	    ungetc (c, fp);
	    *d = '\0';
	    return buf;
	}
	/*
	 * if the buffer is empty and we immediately see a
	 * newline, we've hit the blank line at the end of
	 * the header.
	 */
	if ((d - buf) == 0) {
	    if (c == '\n') {
		*d++ = c;
		*d = '\0';
		return buf;
	    }
	    else if (c == '\r') {
		*d++ = c;
		if ((c = getc (fp)) == '\n') {
		    *d++ = c;
		    *d = '\0';
		    return buf;
		}
		else if (c == EOF) {
		    *d = '\0';
		    return buf;
		}
		else
		    ungetc (c, fp);
	    }
	}

	/* stuff the character in the buffer */
	*d++ = c;
	bol = (c == '\n');

	/* size check */
	if (d - buf >= size - 1) {
	    buf[size-1] = '\0';
	    return buf;
	}
    }
    /* at EOF, either return what's already in the buffer, or NULL */
    if (d == buf)
	return NULL;
    else {
	*d = 0;
	return buf;
    }
}

/*
 * return nonzero iff 'buf' is a blank line
 */

int
isblankline (buf)
unsigned char *buf;
{
    if (buf == NULL)
	return 1;
    while (*buf == ' ' || *buf == '\t' || *buf == '\r')
	++buf;
    return (*buf == '\n');
}
