/*
 * routines for downloading libraries
 *
 * error reporting: result package
 * error messages: result package
 *
 * dependencies: netbuild
 *
 * todo:
 */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "concat.h"
#include "conf.h"
#include "cache.h"
#include "nvpl.h"
#include "result.h"
#include "str.h"
#include "unpack.h"

void
read_metadata (struct result *x, FILE *fp)
{
    char buf[1024];

    while (fgets (buf, sizeof (buf), fp)) {
	char *colon = strchr (buf, ':');
	char *nl = strchr (buf, '\n');

	if (nl)
	    *nl = '\0';
	if (colon) {
	    *colon = '\0';
	    if (strncmp (buf, "library.", 8) == 0)
		x->nvpl = add_nvp (x->nvpl, strdup (buf), strdup (colon+1));
	}
    }
}

/*
 * download a library from a server, using a cached copy
 * if we have one.
 *
 * needs to return:
 * - status:
 *   success, not found, malformed, sig verify failure, etc.
 * - local filename where library is stored
 */

int
download_library (struct result *x, char *url, char *libname)
{
    char *package_fn;
    char *temp_dirname;
    char *metadata_fn;
    FILE *fp;
    extern int verbosity;		/* XXX */

    /*
     * download the resource from the location indicated by the
     * package url
     */
    if ((package_fn = download_file_via_cache (url, libname)) == NULL)
	return failure (x, 1, "unable to download %s\n", url);

    /*
     * concoct temp dir name to be used for extracting contents
     */
#ifdef HAVE_ASPRINTF
    asprintf (&temp_dirname, "%s/NetBuild/cache/%s",
	      getenv ("HOME"), hash_uri (url));
#else
    temp_dirname = concat (getenv ("HOME"), "/NetBuild/cache/",
			   hash_uri (url), NULL);
#endif

    /*
     * unpack the contents into that directory
     */
    if (unpack_and_verify_package (x, temp_dirname, package_fn, verbosity) != 0) {
#if 0
	fprintf (stderr, "unpack_and_verify_package (x, %s, %s) failed\n",
		 temp_dirname, package_fn);
#endif
	return x->status;
    }

#if 0
    printf ("package %s unpacked and verified okay\n", package_fn);
#endif

#if 0
    /*
     * make sure there's a library there matching libname
     */
    if (check_for_library (temp_dirname, libname) < 0)
	return failure (x, 1, "no library matching '%s' in %s",
			libname, url);
#endif

#if 1
    /*
     * read in metadata, looking for link.argN attributes and 
     * adding them to the result structure
     */
    metadata_fn = concat (temp_dirname, "/metadata", NULL);
    if (fp = fopen (metadata_fn, "r")) {
	int status;

	success_nvpl (x, "localdir", temp_dirname, NULL, NULL);
	read_metadata (x, fp);
	fclose (fp);
	return x->status;
    }
    else {
	return failure (x, 1, "no metadata component in %s", url);
    }
#endif

    return success_nvpl (x, "localdir", temp_dirname, NULL, NULL);
}

#ifdef TEST
int verbosity;

main (int argc, char **argv)
{
    struct result x;
    struct nvpl *foo;

    verbosity = 1;
    download_library (&x, argv[1], argv[2]);
    if (x.status != 0) {
	fprintf (stderr, "status = %d\n", x.status);
	fprintf (stderr, "message = %s\n", x.msg);
    }
    for (foo = x.nvpl; foo; foo=foo->next) {
	fprintf (stderr, "%s=\"%s\"\n", foo->name, foo->value);
    }
}
#endif
