/*
 * generic list. super-class of all other lists defined here
 */

struct list {
    void *next;
};

/*
 * list of strings
 */

struct string_list {
    struct string_list *next;
    char *this;
};

/*
 * list of command-line options that we might need to recognize,
 * with instructions for how to process them
 */

struct option {
    struct option *next;
    char *pattern;
    int nargs;			/* number of additional arguments */
    int flags;
#define LIBARG		01
#define STATIC		02
#define DYNAMIC		04
#define LOCALDIR	010
#define NETBUILDONLY	020
#define VERBOSE		040
};

/*
 * list of patterns matching library filenames
 */

struct pattern {
    struct pattern *next;
    char *pat;
    int flags;
};

void append (struct list **, struct list *);
void append_string (struct string_list **, char *);
char *find_config_file (char *, char *);
int read_config (char *, char *, char *);
