/*
 * copy a file
 *
 * error reporting: function return values
 * error messages: none in copyfile(), stderr in copyfile_noisy()
 *
 * dependencies: none
 *
 * todo:
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

/*
 * copy a file from 'source' to 'dest', preserving permission
 * but not ownership.
 *
 * return values:
 * 0 successful
 * -1 source file open error
 * -2 destination file open/create error
 * -3 read error
 * -4 write/close error
 */

int
copyfile (char *source, char *dest)
{
    int sfd = -1;
    int dfd = -1;
    struct stat st;
    char buf[1024*32];
    char *ptr;
    int nread, nwritten;
    int status;

    if ((sfd = open (source, O_RDONLY, 0)) < 0) {
	status = -1;
	goto err;
    }
    if (fstat (sfd, &st) < 0) {
	status = -3;
	goto err;
    }
    if ((dfd = open (dest, O_WRONLY|O_CREAT|O_TRUNC,
		     st.st_mode & 0777)) < 0) {
	status = -2;
	goto err;
    }
    while ((nread = read (sfd, buf, sizeof (buf))) > 0) {
	ptr = buf;
	while (nread > 0) {
	    nwritten = write (dfd, ptr, nread);
	    if (nwritten <= 0) {
		status = -4;
		goto err;
	    }
	    nread -= nwritten;
	    ptr += nwritten;
	}
    }
    if (nread < 0) {
	status = -3;
	goto err;
    }
    if (close (dfd) < 0) {
	status = -4;
	goto err;
    }
    fchmod (dfd, st.st_mode & 0777);
    close (sfd);
    return 0;

 err:
    if (sfd >= 0)
	close (sfd);
    if (dfd >= 0) {
	close (dfd);
	unlink (dest);
    }
    return status;
}

/*
 * copy a file and complain if it fails
 */

int
copyfile_noisy (char *source, char *dest, FILE *fp, char *name)
{
    int status = copyfile (source, dest);

    if (fp == NULL)
	return status;
    if (name == NULL)
	name = "copyfile";

    switch (status) {
    case 0:
	return status;
    case -1:
	fprintf (fp, "%s: can't open \"%s\" (%s)\n",
		 name, source, strerror (errno));
	return status;
    case -2:
	fprintf (fp, "%s: can't open \"%s\" for writing (%s)\n",
		 name, dest, strerror (errno));
	return status;
    case -3:
	fprintf (fp, "%s: error reading \"%s\" (%s)\n",
		 name, source, strerror (errno));
	return status;
    case -4:
	fprintf (fp, "%s: error writing or closing \"%s\" (%s)\n",
		 name, source, strerror (errno));
	return status;
    default:
	fprintf (fp, "%s: unknown error %d in copyfile (%s)\n",
		 name, status, strerror (errno));
	return status;
    }
}

#ifdef TEST
main (int argc, char **argv)
{
    copyfile_noisy (argv[1], argv[2], stderr, NULL);
}
#endif
