/*
 * concatenate one or more strings passed in a variable-length argument list
 * the list is terminated by a NULL pointer argument
 *
 * e.g.
 * result = concat ("a", "bc", "def", NULL);
 * result is "abcdef"
 *
 * result is malloc()ed from heap storage and should be free()d
 *
 * error reporting: returns NULL if it cannot allocate enough memory.
 *
 * error messages: none
 *
 * dependencies: none.
 *
 * todo:
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

char *
concat (char *arg0, ...)
{
    int length;
    char *result;
    char *s, *d;
    va_list ap;

    length = 1;
    length += strlen (arg0);

    va_start (ap, arg0);
    while (s = va_arg (ap, char *))
	length += strlen (s);
    va_end (ap);

    if ((result = malloc (length)) == NULL)
	return NULL;

    d = result;
    s = arg0;
    while (*s)
	*d++ = *s++;

    va_start (ap, arg0);
    while (s = va_arg (ap, char *)) {
	while (*s)
	    *d++ = *s++;
    }
    va_end (ap);

    *d++ = '\0';
    return result;
}
