/* 
 * Implementation of the library routine basename() for systems
 * that don't have it.
 *
 * error reporting: returns NULL
 * error messages: none
 * dependencies: conf.h (HAVE_BASENAME), basename.h
 *
 */

/*
 * From the NetBSD man page:
 *
 * The basename() function takes the pathname pointed to by path and returns
 * a pointer to the final component of the pathname, deleting and trailing
 * '/' characters.
 *
 * If path consists entirely of '/' characters, basename() returns a pointer
 * to the string "/".
 *
 * If path is a null pointer or points to an empty string, basename() re-
 * turns a pointer to the string ".".
 */

#include "conf.h"

#ifndef HAVE_BASENAME
#include <stdio.h>
#include <string.h>
#include "basename.h"

char *
basename (char *path)
{
    char *slash;

    /* if NULL or null string, return "." */
    if (path == NULL || *path == '\0')
	return ".";

    /* delete any trailing '/'s */
    while ((slash = strrchr (path, '/')) != NULL && *(slash+1) == '\0')
	*slash = '\0';
    if (*path == '\0')
	return "/";
    if (slash == NULL)
	return path;
    return slash + 1;
}
#endif /* HAVE_BASENAME */

/*
 * this is an attempt to keep gcc on alpha from barfing
 * when we link in basename.o  and HAVE_BASENAME is undefined.
 */

int
basename_frob ()
{
    return 0;
}

#ifdef TEST
main (int argc, char **argv)
{
    int i;

    for (i = 1; i < argc; ++i)
	printf ("%s\n", basename (argv[i]));
}
#endif
