/*
 * routine for generating a date in RFC 822 format
 *
 * returns a statically-allocated string that is reused with each call
 *
 * error reporting: function returns NULL
 * error messages: none
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include "arpadate.h"

char *
arpadate (t)
time_t *t;
{
    struct tm gmt;
    struct tm *lt;
    static char datebuf[100];
    int gmtoff;
    char sign;
    static char *months[] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
    };
    static char *wdays[] = {
	"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
    };
    
    if (t == NULL)
	return NULL;

    /*
     * "I'm ashamed of this."  - SEK
     *
     * there's no portable function to get the offset between local time
     * and gmt.  so we call both localtime() and gmtime() with the same
     * time clock and calculate the difference.   also, gmtime() and
     * localtime() share the same static return structure, so we have to
     * copy the result of one before we call the other.  yeech.
     */
    gmt = *gmtime (t);
    lt = localtime (t);
    gmtoff = (lt->tm_hour - gmt.tm_hour) * 60 + lt->tm_min - gmt.tm_min;
    if (lt->tm_year != gmt.tm_year)
	gmtoff += (lt->tm_year - gmt.tm_year) * 24 * 60;
    else
	gmtoff += (lt->tm_yday - gmt.tm_yday) * 24 * 60;

    sign = '+';
    if (gmtoff < 0) {
	sign = '-';
	gmtoff = -gmtoff;
    }
    sprintf (datebuf, "%s, %d %s %04d %02d:%02d:%02d %c%02d%02d",
	     wdays[lt->tm_wday], lt->tm_mday, months[lt->tm_mon],
	     lt->tm_year + 1900, lt->tm_hour, lt->tm_min, lt->tm_sec,
	     sign,
	     gmtoff / 60,
	     gmtoff % 60);

    return datebuf;
}
