/*
 * description: test for altivec instruction set extension on PPC
 *
 * status: this is just an example program, for now
 *
 * todo: integrate into generalized ppc cpu handling
 */

#include <stdio.h>
#include <sys/types.h>
#ifdef OS_darwin
#include <sys/sysctl.h> 
#endif
#include <signal.h> 
#include <setjmp.h>

static sigjmp_buf jmpbuf;
static volatile sig_atomic_t canjump = 0;
 
static void sigill_handler (int sig) 
{
    if (!canjump) { 
        signal (sig, SIG_DFL);
        raise (sig);
    }
 
    canjump = 0;
    siglongjmp (jmpbuf, 1);
}

   
#ifdef OS_darwin
int darwin_has_altivec ()
{
    int sels[2] = {CTL_HW, HW_VECTORUNIT};
    int has_vu = 0;
    size_t len = sizeof(has_vu);
    int err;
   
    err = sysctl(sels, 2, &has_vu, &len, NULL, 0);
   
    if (err != 0)
	return 0;
    return  (has_vu != 0);
}
#endif

int gcc_has_altivec ()
{
    int result = 0;

    signal (SIGILL, sigill_handler);
    if (sigsetjmp (jmpbuf, 1)) {
	signal (SIGILL, SIG_DFL);
    } 
    else { 
        canjump = 1;
	asm volatile ("mtspr 256, %0\n\t"
                      "vand %%v0, %%v0, %%v0"
                      :
                      : "r" (-1));
   
	signal (SIGILL, SIG_DFL);
	result = 1;
    }
    return result;
}

main ()
{
#ifdef OS_darwin
    printf ("darwin_has_altivec = %d\n", darwin_has_altivec ());
#endif
    printf ("gcc_has_altivec = %d\n", gcc_has_altivec ());
}
