#include <stdio.h>
#include <stdlib.h>
#include <sys/utsname.h>

/*
 * mapping of model ID codes to machine ID
 * note that many ID codes are used for multiple models
 */

struct {
    char *id;
    char *name;
} machines[] = {
    { "02", "7015-930" }, 
    { "10", "7013-530" },
    /* { "10", "7016-730" },  */
    { "11", "7013-540" }, 
    { "14", "7013-540" }, 
    { "18", "7013-530H" }, 
    { "1C", "7013-550" }, 
    { "20", "7015-930" }, 
    { "2E", "7015-950" }, 
    { "30", "7013-520" },
    /* { "30", "7018-740" },  */
    { "31", "7012-320" }, 
    { "34", "7013-520H" }, 
    { "35", "7012-320H" }, 
    { "37", "7012-340" }, 
    { "38", "7012-350" }, 
    { "41", "7011-220"  "rsc", "33MHz" }, 
    { "42", "7006-410", "ppc601", "80MHz" }, 
    { "43", "7008-M20", "power", "33MHz" },
    /* { "43", "7008-M20A", "power", "33Mhz" }, */
    { "46", "7011-250", "ppc", "66MHz" }, 
    { "47", "7011-230", "rsc", "45MHz" }, 
    { "48", "7009-C10", "ppc601", "80MHz" }, 
    { "49", "7011-25F", "ppc601", "80MHz" },
    /* { "4C", "7043-140" },  */
    /* { "4C", "7043-240" },  */
    /* { "4C", "7428-43P" },  */
    /* { "4C", "7026-H10" },  */
    { "4D", "7020-40P" },
    { "57", "7012-390", "power2", "67MHz" }, 
    /* { "57", "7030-3BT" },  */
    { "58", "7012-380" },
    /* { "58", "7030-3AT" },  */
    { "59", "7012-39H" },
    /* { "59", "7030-3CT" }, */
    { "5C", "7013-560" }, 
    { "63", "7015-970" },
    /* { "63", "7015-970B" }, */
    { "64", "7015-980" },
    /* { "64", "7015-980B" }, */
    { "66", "7013-580" }, 
    { "67", "7013-570" },
    /* { "67", "7015-R10" },  */
    /* { "67", "7018-770" },  */
    { "70", "7013-590" }, 
    { "71", "7013-58H" }, 
    { "72", "7013-590H" },
    /* { "72", "7015-R20" },  */
    { "75", "7012-370" }, 
    /* { "75", "7012-375" },  */
    { "76", "7012-360" },
    /* { "76", "7012-365" },  */
    { "77", "7012-350" },
    /* { "77", "7012-355" },  */
    /* { "77", "7013-550L" }, */
    { "79", "7015-R21" },
    /* { "79", "7013-591" }	XXX anecdotal */
    { "80", "7015-990" }, 
    { "81", "7015-R24" }, 
    { "82", "7015-R24" },
    { "89", "7013-595" },
    { "90", "7009-C20", "ppc604", "120Mhz" },
    { "91", "7006-42*", "ppc604", "120MHz" },	/* 7006/42W/42T */
    { "A0", "7013-J30" }, 	/* 601 or 604 */
    { "A1", "7013-J40" }, 
    { "A3", "7015-R30" }, 	/* 601 or 604 */
    { "A4", "7015-R40" }, 	/* also R50 */
    { "A6", "7012-G30" },	/* 601 or 604 */ 
    { "A7", "7012-G40" }, 
    { "C0", "7024-E20" }, 	/* also E30 */
    { "C4", "7025-F30" }, 
    { "F0", "7007-N40" }, 	/* notebook */
};

/* xxyyyyyymmss 
   012345678901*/

/*
 * the 'machine' field of the 'utsname' structure filled in by uname()
 * is of the form xxyyyyyymmss where
 * xx is 00
 * yyyyyy is a per-system unique id #
 * mm is a model ID of the CPU planar
 * ss is a submodel number (should be zero)
 */

lookup_cpu (char *machine)
{
    int i;
    for (i = 0; i < sizeof (machines)/sizeof (*machines); ++i) {
	if (strncmp (machine+8, machines[i].id, 2) == 0)
	    return machines[i].name;
    }
}

main ()
{
    struct utsname foo;

    uname (&foo);
    name = lookup_cpu (foo.machine);
    printf ("name = %s\n", name);
}
