/*
 * routines for finding a library on the net
 */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>
/* #include "arch.h" */
#include "conf.h"
#include "httpget.h"
#include "netfind.h"
#include "nvpl.h"
#include "pathnames.h"
#include "platform.h"

extern int verbose;

struct nvpl *
parse_description_file (FILE *fp, char *url)
{
    struct nvpl *candidate_list = new_nvpl ();
    char *current_candidate_fn = NULL;
    struct nvpl *current_candidate = NULL;
    char buf[10240];
    int lineno = 0;

    while (fgets (buf, sizeof (buf), fp) != NULL) {
	++lineno;
	if (*buf == '#' || *buf == '\n' || *buf == '\r')
	    ;
	else if (*buf == ' ' || *buf == '\t') {
	    fprintf (stderr, "malformed candidate list: line %d in %s\n",
		     lineno, url);
	    return NULL;
	}
	else if (*buf == '[') {
	    char *ket = strchr (buf+1, ']');

	    if (ket == NULL) {
		/* malformed line */
		fprintf (stderr, "malformed candidate list: line %d in %s\n",
			 lineno, url);
		return NULL;
	    }
	    *ket = '\0';

	    if (current_candidate_fn != NULL) {
		candidate_list = add_nvp (candidate_list,
					  current_candidate_fn,
					  (char *) current_candidate);
	    }
	    current_candidate_fn = strdup (buf+1);
	    current_candidate = new_nvpl ();
	}
	else {
	    char *colon = strchr (buf, ':');

	    if (colon == NULL) {
		fprintf (stderr, "malformed candidate list: line %d in %s\n",
			 lineno, url);
		return NULL;
	    }
	    *colon++ = '\0';
	    while (*colon == ' ')
		++colon;
	    current_candidate = add_nvp (current_candidate,
					 strdup (buf),
					 strdup (colon));
	}
    }
    if (current_candidate_fn != NULL) {
	candidate_list = add_nvp (candidate_list,
				  current_candidate_fn,
				  (char *) current_candidate);
    }
    return candidate_list;
}


/*
 * given a list of candidate libraries on 'fp', pick the best match
 */

char *
pick_best_match (FILE *fp)
{
    char *best_filename = NULL;
    int best_match_figure = -10000;
    char *filename = NULL;
    int match_figure = -10000;
    char buf[1024];

    while (fgets (buf, sizeof (buf), fp) != NULL) {
	if (*buf == '[') {
	    char *ket;

	    if (ket = strchr (buf+1, ']')) {
		*ket = NULL;
		filename = strdup (buf+1);
	    }
	}
    }
    
}



/*
 * find the library named 'libname' on netlib server 'server'
 *
 * method - GET a well-known HTTP URL, defined from the library name,
 * relative to the server root.
 *
 * XXX - this is too primitive a matching algorithm for real-world use.
 */

#if 1
char *
find_on_server (char *server, char *libname)
{
    FILE *fp;
    char *url;
    char *myarch;
    char *result;

    myarch = get_netbuild_arch ();
    asprintf (&url, "%s/%s/%s/netbuild.index", server, libname, myarch);
    
    /* XXX why bypass cache? */
    if ((fp = http_get_internal (url, 0, NULL)) == NULL) {
	if (verbose)
	    fprintf (stderr, "netbuild: URL %s not found\n", url);
	return NULL;
    }
    result = pick_best_match (fp);
    fclose (fp);
    return result; 
}
#else
char *
find_on_server (char *server, char *libname)
{
    FILE *fp;
    char url[1024];
    char buf[1024];
    char *myarch;
    char arch[1024];
    static char id[1024];

    myarch = get_myarch ();

    /* XXX potential overflow of 'url' */
    sprintf (url, "%s/find_library/%s", server, libname);

    if ((fp = http_get_internal (url, 0, NULL)) == NULL) {
	if (verbose)
	    fprintf (stderr, "netbuild: URL %s not found\n", url);
	return NULL;
    }
    while (fgets (buf, sizeof (buf), fp) != NULL) {
#if 0
	if (verbose)
	    fprintf (stderr, ">>> %s\n", buf);
#endif
	/* 
	 * XXX is it portable to test the return value from sscanf? 
	 * XXX potential overflow of 'arch' and 'id'
         */
	if (sscanf (buf, "%s %s", arch, id) == 2) { 
	    if (strcmp (arch, myarch) == 0) {
		fclose (fp);
		if (verbose) {
		    fprintf (stderr, "netbuild: found match for %s at\n", 
			     libname);
		    fprintf (stderr, " %s\n", id);
		}
		return id;
	    }
	}
    }
    fclose (fp);
    return NULL;
}
#endif

#if 0

/*
 * extract the host portion of an HTTP (and perhaps other kinds of) url
 * result string is malloc'ed from heap space.
 */

char *
gethost (char *url)
{
    char *copy = strdup (url);
    char *p1, *p2;
    char *result;

    /* skip prefix */
    for (p1 = copy; *p1 && *p1 != ':'; ++p1);
    if (*p1 == '\0')
	goto fail;
    /* skip slashes */
    while (*p1 == '/')
	++p1;
    /* look for ':' or '/' ending hostname */
    for (p2 = p1; *p2 && *p2 != '/' && *p2 != ':'; ++p2);
    if (*p2 == '\0')
	goto fail;
    *p2 = '\0';
    result = strdup (p1);
    free (copy);
    return strlower (result);

 fail:
    free (copy);
    return NULL;
}


/* XXX not currently used */

/*
 * download an HTTP url and save in a filename appropriate for libname
 *
 * XXX assumes that the filename is of the form lib%s.a 
 * XXX for now, only works when downloading .a and fragments of .tgz files
 * XXX doesn't do any kind of integrity or authenticity verification yet 
 */

char *
download (char *url, char *libname)
{
    FILE *src;
    FILE *dst;
    static char dir[1024];
#if 0
    time_t now;
    struct tm *tm;
    char hostname[1024];
#endif
    char localname[1024];
    int nread;
    char buf[32*1024];
    char *baseurl;
    char *fragment;


    /* 
     * separate base and fragment portions of the URL 
     */
    if (fragment = strchr (url, '#')) {
	*fragment = '\0';
	baseurl = strdup (url);
	*fragment = '#';
	fragment = strdup (fragment+1);
    }
    else {
	baseurl = strdup (url);
	fragment = strdup ("");
    }

#if 1
    /* 
     * determine what a directory would be used to store this 
     * file in the cache.  
     *
     * XXX should base this on the URL from which the file
     * is retrieved - instead of on target platform, libname, etc.
     */
    sprintf (dir, "%s/.netbuild/cache/%s/%s/%s",
	     getenv ("HOME"), get_myarch (), gethost (url), libname);
    if (mkdir_recursive (dir, 0700) < 0)
	exit (1);
#else
    time (&now);
    tm = localtime (&now);
    /* XXX non-portable */
    gethostname (hostname, sizeof (hostname));

    sprintf (dir, "%s/.netbuild/cache/%04d%02d%02d%02d%02d%02d@%s-%d",
	     getenv ("HOME"),
	     tm->tm_year, tm->tm_mon, tm->tm_mday,
	     tm->tm_hour, tm->tm_min, tm->tm_sec,
	     hostname, getpid ());
    if (mkdir (dir, 0700) < 0) {
	fprintf (stderr, "netbuild: cannot create directory %s: %s\n",
		 dir, strerror (errno));
	exit (1);
    }
#endif

    /*
     * XXX multiple hacks for demonstration purposes.
     * these need to be dyked out for distributed code
     *
     * 1. if the URL we are downloading has no fragment identifier,
     * assume it's a normal .a file (or whatever) and save the file
     * using the same filename it had on the server
     */
    if (*fragment == '\0') {
	/* XXX potential overflow of localname */
	sprintf (localname, "%s/%s", dir, basename (baseurl));
	if ((dst = fopen (localname, "w")) == NULL) {
	    fprintf (stderr, "netbuild: cannot create %s: %s\n", localname,
		     strerror (errno));
	    exit (1);
	}
	if (verbose) {
	    fprintf (stderr, "netbuild: downloading\n");
	    fprintf (stderr, " %s\n", url);
	    fprintf (stderr, " to %s\n", localname);
	}
	if ((src = http_get_internal (baseurl, 0, NULL)) == NULL) {
	    fprintf (stderr, "netbuild: cannot download %s\n", url);
	    exit (1);
	}
	while ((nread = fread (buf, 1, sizeof (buf), src)) > 0) {
	    fwrite (buf, 1, nread, dst);
	}
	fclose (dst);
	fclose (src);
    }
    /*
     * 2. if the URL does have a fragment identifier, download
     * it, extract the file named after the fragment, and
     * rename that file as necessary
     */
    else {
	char *bn = basename (baseurl);
	int bnl = strlen (bn);

	if (strcmp (bn + bnl - 4, ".tgz") == 0 ||
	    strcmp (bn + bnl - 7, ".tar.gz") == 0) {
	    
	    /* XXX potential overflow of localname */
	    sprintf (localname, "%s/%s", dir, bn);
	    if ((dst = fopen (localname, "w")) == NULL) {
		fprintf (stderr, "netbuild: cannot create %s: %s\n", localname,
			 strerror (errno));
		exit (1);
	    }
	    if (verbose) {
		fprintf (stderr, "netbuild: downloading\n");
		fprintf (stderr, " %s\n", url);
		fprintf (stderr, " to %s\n", localname);
	    }
	    if ((src = http_get_internal (baseurl, 0, NULL)) == NULL) {
		fprintf (stderr, "netbuild: cannot download %s\n", url);
		exit (1);
	    }
	    while ((nread = fread (buf, 1, sizeof (buf), src)) > 0) {
		fwrite (buf, 1, nread, dst);
	    }
	    fclose (dst);
	    fclose (src);
	    /*
	     * XXX this is horrible, but it's just a demo
	     */
#ifdef PATH_GUNZIP
	    sprintf (buf, "cd '%s'; '%s' < '%s' | %s xfp - '%s'",
		     dir, PATH_GUNZIP, bn, PATH_TAR, fragment);
#else
	    sprintf (buf, "cd '%s'; %s xfpz '%s' '%s'",
		     dir, PATH_TAR, bn, fragment);
#endif
	    if (verbose)
		fprintf (stderr, "%s\n", buf);
	    system (buf);
	    sprintf (buf,
		     "mv '%s/%s' '%s/lib%s.a'", dir, fragment, dir, libname);
	    if (verbose)
		fprintf (stderr, "%s\n", buf);
	    system (buf);
#if 0
/*
 * apparently, most systems don't need this any more, it slows
 * things down, and tar preserves dates anyway.  so let's not do it
 */
#ifdef PATH_RANLIB
	    sprintf (buf,
                     "cd %s; %s lib%s.a", dir, PATH_RANLIB, libname);
	    if (verbose)
		fprintf (stderr, "%s\n", buf);
	    system (buf);
#endif
#endif
	    unlink (localname);
	}
	else {
	    fprintf (stderr,
		     "netbuild: I don't know how to extract %s from %s\n",
		     fragment, bn);
	    fprintf (stderr,
                     "          unknown container file format\n");
	    exit (1);
	}
    }
    free (fragment);
    free (baseurl);
    return dir;
}

#endif
