#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "conf.h"
#include "dirname.h"

/*
 *   Supply a private dirname() function.  On some systems, dirname()
 *   returns a pointer to a static buffer.  On others, dirname()
 *   clobbers its argument.  This is a pain because on the first kind of
 *   system you want to do parent = strdup (dirname (child))
 *   while on the others you want to do parent = dirname (strdup (child))
 *   rather than try to write code that works on either kind of system,
 *   we'll just define our own my_dirname() function that uses a static
 *   buffer.
 *
 *   From the NetBSD man page:
 *
 *   The dirname() function takes a pointer to a character string that con-
 *   tains a pathname, path, and returns a pointer to a string that is a path-
 *   name of the parent directory of path.  Trailing '/' characters in path
 *   are not counted as part of the path.
 *
 *   If path does not contain a '/', then dirname() returns a pointer to the
 *   string ".".
 *
 *   If path is a null pointer or points to an empty string, dirname() returns
 *   a pointer to the string ".".
 *
 *   The path is modified in-place, so if you want path to be unchanged
 *   you need to do dirname (strdup (path))
 */

char *
my_dirname (char *path)
{
    char *slash;
    static char mypath[1024];

    if (path == NULL || *path == '\0')
        return ".";
    if (path[0] == '/' && path[1] == '\0')
        return path;
    if (strlen (path) + 1 > sizeof(mypath))
	return NULL;
    strcpy (mypath, path);
    if (slash = strrchr (mypath, '/')) {
        *slash = '\0';
        return mypath;
    }
    return ".";
}

#ifdef TEST
main (int argc, char **argv)
{
    int i;

    for (i = 1; i < argc; ++i)
        printf ("%s\n", dirname (argv[i]));
}
#endif

