      PROGRAM TESTDGESV
*
*     Susan Blackford  -- May 19, 1999
*
*  Purpose
*  =======
*
*  TESTDGESV tests the LAPACK routine DGESV, to solve a system
*  of linear equations.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            N, LDA, NRHS
      PARAMETER          ( N = 100, LDA = N+1, NRHS = 1 )
      INTEGER            NOUT
      PARAMETER          ( NOUT = 6 )
      DOUBLE PRECISION   ONE, TWO
      PARAMETER          ( ONE = 1.0D+0, TWO = 2.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, INFO, K, NFAIL
      DOUBLE PRECISION   ANORM, CNDNUM, THRESH
*     ..
*     .. Local Arrays ..
      INTEGER            ISEED( 4 ), ISEEDY( 4 ), IWORK( LDA )
      DOUBLE PRECISION   A( LDA, N ), AFAC( LDA, N ), B( LDA, NRHS ),
     $                   RESULT( 2 ), RWORK( LDA ), WORK( 3*LDA ),
     $                   X( LDA, NRHS ), XACT( LDA, NRHS )
*     ..
*     .. External Subroutines ..
      EXTERNAL           DGESV, DGET01, DGET02, DLACPY, DLARHS, DLATMS
*     ..
*     .. Data statements ..
      DATA               ISEEDY / 1988, 1989, 1990, 1991 /
*     ..
*     .. Executable Statements ..
*
*     Initialize constants and the random number seed.
*
      THRESH = 10.0D0
*
      DO 10 I = 1, 4
         ISEED( I ) = ISEEDY( I )
   10 CONTINUE
*
*     Generate a test matrix with DLATMS and rhs matrix with DLARHS.
*
      CNDNUM = TWO
      ANORM = ONE
*
      CALL DLATMS( N, N, 'S', ISEED, 'N', RWORK, 3, CNDNUM, ANORM, 0, 0,
     $             'No packing', A, LDA, WORK, INFO )
      CALL DLARHS( 'DGE', 'N', 'Full', 'N', N, N, 0, 0, NRHS, A, LDA,
     $             XACT, LDA, B, LDA, ISEED, INFO )
*
      CALL DLACPY( 'Full', N, N, A, LDA, AFAC, LDA )
      CALL DLACPY( 'Full', N, NRHS, B, LDA, X, LDA )
*
*     Compute the LU factorization of the matrix and solve the system.
*
      CALL DGESV( N, NRHS, AFAC, LDA, IWORK, X, LDA, INFO )
*
*     Check error code from DGESV.
*
      IF( INFO.NE.0 ) THEN
         WRITE( NOUT, FMT = * )'ERROR: DGESV INFO=', INFO
         GO TO 30
      END IF
*
*     Reconstruct matrix from factors and compute residual.
*          norm(L*U - A) / ( N * norm(A) * EPS )
*
      CALL DGET01( N, N, A, LDA, AFAC, LDA, IWORK, RWORK, RESULT( 1 ) )
*
*     Compute residual of the computed solution.
*          norm(B - A*X) / ( norm(A) * norm(X) * EPS )
*
      CALL DGET02( 'No transpose', N, N, NRHS, A, LDA, X, LDA, B, LDA,
     $             RWORK, RESULT( 2 ) )
*
*     Print information if the tests did not pass the threshold.
*
      NFAIL = 0
      DO 20 K = 1, 2
         IF( RESULT( K ).GE.THRESH ) THEN
            NFAIL = NFAIL + 1
            WRITE( NOUT, FMT = 9999 )'DGESV ', N, 1, K, RESULT( K )
         END IF
   20 CONTINUE
*
      IF( NFAIL.EQ.0 ) THEN
         WRITE( NOUT, FMT = 9998 )
c        WRITE( NOUT, FMT = * )
      END IF
*
   30 CONTINUE
*
 9999 FORMAT( 1X, A6, ', N =', I5, ', type ', I2, ', test(', I2, ') =',
     $      G12.5 )
 9998 FORMAT( / 1X, 'All tests for DGESV passed the threshold' / )
*
*     End of TESTDGESV
*
      END
