      PROGRAM TESTDGEEV
*
*     Susan Blackford  -- May 19, 1999
*
*  Purpose
*  =======
*
*  TESTDGEEV tests the LAPACK routine DGEEV, to solve the general
*  eigensystem (Ax = lambda*x).
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            N, LDA
      PARAMETER          ( N = 100, LDA = N+1 )
      INTEGER            NOUT
      PARAMETER          ( NOUT = 6 )
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, INFO, K, NFAIL, NNWORK
      DOUBLE PRECISION   ANORM, THRESH, ULP, ULPINV
*     ..
*     .. Local Arrays ..
      INTEGER            IDUMMA( 1 ), IOLDSD( 4 ), ISEED( 4 ),
     $                   ISEEDY( 4 ), IWORK( LDA )
      DOUBLE PRECISION   A( LDA, N ), H( LDA, N ), RES( 2 ),
     $                   RESULT( 2 ), VL( LDA, N ), VR( LDA, N ),
     $                   WI( LDA ), WORK( 3*N+5*N**2 ), WR( LDA )
*     ..
*     .. External Subroutines ..
      EXTERNAL           DGEEV, DGET22, DLACPY, DLASET, DLATMR
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   DLAMCH
      EXTERNAL           DLAMCH
*     ..
*     .. Data statements ..
      DATA               ISEEDY / 1988, 1989, 1990, 1991 /
*     ..
*     .. Executable Statements ..
*
*     Initialize constants and the random number seed.
*
      THRESH = 10.0D0
      ULP = DLAMCH( 'Precision' )
      ULPINV = ONE / ULP
      ANORM = ONE
*
      DO 10 I = 1, 4
         ISEED( I ) = ISEEDY( I )
   10 CONTINUE
*
*     Save ISEED in case of an error.
*
      DO 20 K = 1, 4
         IOLDSD( K ) = ISEED( K )
   20 CONTINUE
*
*     Generate a test matrix (General, random eigenvalues) with DLATMR
*
      CALL DLATMR( N, N, 'S', ISEED, 'N', WORK, 6, ONE, ONE, 'T', 'N',
     $             WORK( N+1 ), 1, ONE, WORK( 2*N+1 ), 1, ONE, 'N',
     $             IDUMMA, N, N, ZERO, ANORM, 'NO', A, LDA, IWORK,
     $             INFO )
      IF( N.GE.4 ) THEN
         CALL DLASET( 'Full', 2, N, ZERO, ZERO, A, LDA )
         CALL DLASET( 'Full', N-3, 1, ZERO, ZERO, A( 3, 1 ), LDA )
         CALL DLASET( 'Full', N-3, 2, ZERO, ZERO, A( 3, N-1 ), LDA )
         CALL DLASET( 'Full', 1, N, ZERO, ZERO, A( N, 1 ), LDA )
      END IF
*
*     Compute eigenvalues and eigenvectors, and test them
*
      NNWORK = 5*N + 2*N**2
      CALL DLACPY( 'F', N, N, A, LDA, H, LDA )
      CALL DGEEV( 'V', 'V', N, H, LDA, WR, WI, VL, LDA, VR, LDA, WORK,
     $            NNWORK, INFO )
      IF( INFO.NE.0 ) THEN
         RESULT( 1 ) = ULPINV
         WRITE( NOUT, FMT = * )'ERROR: DGEEV INFO=', INFO
         GO TO 50
      END IF
*
*     Do Test (1) RESULT(1) = | A E  -  E W | / ( |A| |E| ulp )
*     using the 1-norm
*
      CALL DGET22( 'N', 'N', 'N', N, A, LDA, VR, LDA, WR, WI, WORK,
     $             RES )
      RESULT( 1 ) = RES( 1 )
*
*     Print information if the tests did not pass the threshold.
*
      NFAIL = 0
      DO 30 K = 1, 2
         IF( RESULT( K ).GE.THRESH )
     $      NFAIL = NFAIL + 1
   30 CONTINUE
*
      IF( NFAIL.GT.0 )
     $   WRITE( NOUT, FMT = 9998 )THRESH
*
      DO 40 K = 1, 2
         IF( RESULT( K ).GE.THRESH ) THEN
            WRITE( NOUT, FMT = 9999 )N, IOLDSD, 9, K, RESULT( K )
         END IF
   40 CONTINUE
*
      IF( NFAIL.EQ.0 ) THEN
         WRITE( NOUT, FMT = 9997 )
      END IF
*
   50 CONTINUE
*
 9999 FORMAT( ' N=', I5, ', seed=', 4( I4, ',' ),
     $      ' type ', I2, ', test(', I2, ')=', G10.3 )
 9998 FORMAT( ' Tests performed with test threshold =', F8.2,
     $      / / ' 1 = | A VR - VR W | / ( n |A| |VR| ulp ) ' )
 9997 FORMAT( / 1X, 'All tests for DGEEV passed the threshold', / )
*
*     End of TESTDGEEV
*
      END
