#!/bin/sh
MD5=ae5a445565153a4d7137566f60c74745
BASENAME=libgoto_p4_512-r0.97
DESCR="Intel P4, 512k cache, single-threaded, Linux"
nb -download http://www.cs.utexas.edu/users/kgoto/libraries/$BASENAME.so.gz $BASENAME.so.gz
case "`nb -md5 $BASENAME.so.gz | awk '{print $4}'`" in
	$MD5) ;;
	*) echo md5 check on $BASENAME.so.gz failed >&2 ; exit 1;;
esac
gunzip $BASENAME.so.gz
mv $BASENAME.so libgoto.so
nb -download http://www.cs.utexas.edu/users/kgoto/libraries/xerbla.f xerbla.f
case "`nb -md5 xerbla.f | awk '{print $4}'`" in
	438d5ef5431ce0135b0a4d759741d977) ;;
	*) echo md5 check on xerbla.f failed >&2; exit 1;;
esac
make xerbla.o
ar cq xerbla.a xerbla.o
cat << FOO

Linking to the BLAS implementation by Kazushige Goto
(Visiting Scientist, FLAME project, University of Texas-Austin)
http://www.cs.utexas.edu/users/flame/goto/
(version $DESCR)

If you have not already done so, please sign their guest book at
http://www.cs.utexas.edu/users/flame/guestbook.html

The implementors request that you please:

    * Do not redistribute the library.
    * Reference this work when you use it successfully for your own research.
    * When creating a link to this work from your web page please use 
      something like
          o BLAS by Kazushige Goto (Visiting Scientist, FLAME project, 
            UT-Austin)
      and link to http://www.cs.utexas.edu/users/flame/goto/

FOO
