/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:11 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "sswap.h"
#include <stdlib.h>
void /*FUNCTION*/ sswap(
long n,
float x[],
long incx,
float y[],
long incy)
{
	long int _d_l, _d_m, _do0, _do1, i, ix, iy, m, mp1, ns;
	float temp1, temp2, temp3;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const X = &x[0] - 1;
	float *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 2006-06-07 SSWAP  Krogh   Removed arithmetic ifs
	 *>> 1994-11-11 SSWAP  Krogh   Declared all vars.
	 *>> 1994-10-20 SSWAP  Krogh   Changes to use M77CON
	 *>> 1985-08-02 SSWAP  Lawson  Initial code.
	 *--S replaces "?": ?SWAP
	 *
	 *     INTERCHANGE X and Y.
	 *     FOR I = 0 TO N-1, INTERCHANGE  X(LX+I*INCX) AND Y(LY+I*INCY),
	 *     WHERE LX = 1 IF INCX .GE. 0, ELSE LX = (-INCX)*N, AND LY IS
	 *     DEFINED IN A SIMILAR WAY USING INCY.
	 * */
	if (n <= 0)
		return;
	if ((incx != incy) || (incx < 0))
	{
		/*       CODE FOR UNEQUAL OR NONPOSITIVE INCREMENTS. */
		ix = 1;
		iy = 1;
		if (incx < 0)
			ix = (-n + 1)*incx + 1;
		if (incy < 0)
			iy = (-n + 1)*incy + 1;
		for (i = 1; i <= n; i++)
		{
			temp1 = X[ix];
			X[ix] = Y[iy];
			Y[iy] = temp1;
			ix += incx;
			iy += incy;
		}
	}
	else if (incx == 1)
	{
		/*       CODE FOR BOTH INCREMENTS EQUAL TO 1
		 *       CLEAN-UP LOOP SO REMAINING VECTOR LENGTH IS A MULTIPLE OF 3. */
		m = n%3;
		if (m != 0)
		{
			for (i = 1; i <= m; i++)
			{
				temp1 = X[i];
				X[i] = Y[i];
				Y[i] = temp1;
			}
			if (n < 3)
				return;
		}
		mp1 = m + 1;
		for (i = mp1; i <= n; i += 3)
		{
			temp1 = X[i];
			temp2 = X[i + 1];
			temp3 = X[i + 2];
			X[i] = Y[i];
			X[i + 1] = Y[i + 1];
			X[i + 2] = Y[i + 2];
			Y[i] = temp1;
			Y[i + 1] = temp2;
			Y[i + 2] = temp3;
		}
	}
	else
	{
		/*     CODE FOR EQUAL, POSITIVE, NONUNIT INCREMENTS. */
		ns = n*incx;
		for (i = 1, _do0=DOCNT(i,ns,_do1 = incx); _do0 > 0; i += _do1, _do0--)
		{
			temp1 = X[i];
			X[i] = Y[i];
			Y[i] = temp1;
		}
	}
	return;
} /* end of function */
 
