/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:32:04 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "sstop.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	ONE	1.0e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ sstop(
long k,
long n,
float t[],
float bcoef[],
float *bdif,
long *npc,
float xi[],
float *pc)
{
#define BDIF(I_,J_)	(*(bdif+(I_)*(n)+(J_)))
#define PC(I_,J_)	(*(pc+(I_)*(k)+(J_)))
	long int i, ileft, nderiv;
	float denom, fac;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const Bcoef = &bcoef[0] - 1;
	float *const T = &t[0] - 1;
	float *const Xi = &xi[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-10-20 SSTOP Krogh  Changes to use M77CON
	 *>> 1992-10-27 SSTOP C. L. Lawson, JPL
	 *>> 1988-03-16 C. L. Lawson, JPL
	 *
	 *     Given coeffs, BCOEF(), rel to the B-spline basis, this subr
	 *     computes coeffs, PC(,), rel to the Power basis.
	 *     This code is an adaptation of lines 35-51 of
	 *     the subroutine, BSPLPP, given on pp. 140-141 of
	 *     A PRACTICAL GUIDE TO SPLINES by Carl De Boor, Springer-Verlag,
	 *     1978, however BSPLPP uses the Taylor basis and this subr uses
	 *     the Power basis.
	 *     ------------------------------------------------------------------
	 *     K     [in]  Order of the spline function.  Note that the
	 *           polynomial degree of the pieces of the spline function is
	 *           one less than the order.
	 *     N     [in]  Number of B-spline coefficients.
	 *     T()   [in]  Knot sequence defining the B-spline basis functions.
	 *           Contains N+K values, nondecreasing.  The "proper
	 *           interpolation interval" is from T(K) to T(N+1).
	 *     BCOEF()  [in]  N coefficients, defining a spline function relative
	 *           to the B-spline basis.
	 *     BDIF(,)  [scratch, out]  Array in which differences of the
	 *           B-spline coeffs will be stored.
	 *     NPC   [out]  NPC+1 is the number of distinct values among T(K)
	 *           through T(N+1).  NPC is the number of polynomial pieces
	 *           needed to define the spline function.  The number of
	 *           breakpoints returned in XI() will be NPC.
	 *     (XI(j), j = 1, ..., NPC+1)  [out]  Breakpoints for the Power
	 *           representation of the piecewise polynomial.
	 *           These will be the distinct values from among the knots,
	 *           T(K) through T(N+1).
	 *     ((PC(i,j), i = 1, ..., K), j = 1, ..., NPC)  [out]
	 *           PC(i,j) will be the (i-1)st derivative of the spline
	 *           function at XI(j).  Thus PC(i,j)/(factorial(i-1)) is the
	 *           coefficient of (x-XI(j))**(i-1)
	 *           in the polynomial piece defined over the interval from
	 *           XI(j) to XI(j+1).
	 *     ------------------------------------------------------------------
	 *--S replaces "?": ?STOP, ?SDIF, ?SVALA
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	nderiv = k - 1;
	ssdif( k, n, t, bcoef, nderiv, bdif );
	*npc = 0;
	Xi[1] = T[k];
	for (ileft = k; ileft <= n; ileft++)
	{
		if (T[ileft + 1] != T[ileft])
		{
			*npc += 1;
			Xi[*npc + 1] = T[ileft + 1];
 
			/*              SSVALA sets PC(I,NPC) to be the (I-1)st derivative of
			 *              the curve at XI(NPC) for I = 1, ..., K.
			 *              The subsequent loop divides the Jth derivative by
			 *              factorial(J).
			 * */
			ssvala( k, n, t, nderiv, bdif, Xi[*npc], &PC(*npc - 1,0) );
			denom = ONE;
			fac = ONE;
			for (i = 3; i <= k; i++)
			{
				fac += ONE;
				denom *= fac;
				PC(*npc - 1,i - 1) /= denom;
			}
		}
	}
	return;
#undef	PC
#undef	BDIF
} /* end of function */
 
