/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:11 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "ssdif.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	ZERO	0.0e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ ssdif(
long k,
long n,
float t[],
float bcoef[],
long nderiv,
float *bdif)
{
#define BDIF(I_,J_)	(*(bdif+(I_)*(n)+(J_)))
	long int i, id, kmid;
	float diff, fkmid;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const Bcoef = &bcoef[0] - 1;
	float *const T = &t[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-10-20 SSDIF Krogh  Changes to use M77CON
	 *>> 1992-11-02 SSDIF C. L. Lawson, JPL
	 *>> 1988-03-16 C. L. Lawson, JPL
	 *
	 *     Constructs a divided difference table in BDIF(,), preparatory to
	 *     derivative calculation.
	 *     The subroutine, BSPLPP, given on pp. 140-141 of
	 *     A PRACTICAL GUIDE TO SPLINES by Carl De Boor, Springer-Verlag,
	 *     1978, has been recoded as separate subroutines: DSTOT (or DSTOP)
	 *     calling SSDIF and DSVALA.  This subroutine has the functionality
	 *     of lines 57-71 of BSPLPP in the book.
	 *     ------------------------------------------------------------------
	 *--S replaces "?": ?SDIF
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	for (i = 1; i <= n; i++)
	{
		BDIF(0,i - 1) = Bcoef[i];
	}
	kmid = k;
	for (id = 2; id <= (nderiv + 1); id++)
	{
		kmid -= 1;
		fkmid = (float)( kmid );
		for (i = id; i <= n; i++)
		{
			diff = T[i + kmid] - T[i];
			if (diff != ZERO)
			{
				BDIF(id - 1,i - 1) = fkmid*(BDIF(id - 2,i - 1) - BDIF(id - 2,i - 2))/
				 diff;
			}
			else
			{
				BDIF(id - 1,i - 1) = ZERO;
			}
		}
	}
	return;
#undef	BDIF
} /* end of function */
 
