/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:46 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "sgefsc.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	ZERO	0.0e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ sgefsc(
float *a,
long lda,
long n,
float *b,
long ldb,
long nb,
long ipvt[],
float *rcond,
float z[])
{
#define A(I_,J_)	(*(a+(I_)*(lda)+(J_)))
#define B(I_,J_)	(*(b+(I_)*(ldb)+(J_)))
	long int j;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	long *const Ipvt = &ipvt[0] - 1;
	float *const Z = &z[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-11-11 SGEFSC  Krogh   Declared all vars.
	 *>> 1994-10-20 SGEFSC Krogh  Changes to use M77CON
	 *>> 1987-08-18 SGEFSC Lawson  Initial code.
	 *--S replaces "?": ?GEFSC, ?GECO, ?GESLD
	 *
	 *     Solves a system of linear equations,  A * X = B,
	 *     where A is a square nonsingular matrix of order N and B is an
	 *     N by NB matrix.  The solution is the N by NB matrix X that will
	 *     be stored on return in place of B in the array B().
	 *     Sets RCOND to an estimate of the reciprocal of the condition
	 *     number of A.
	 *     ------------------------------------------------------------------
	 *     Uses subroutines derived from LINPACK.
	 *     Ref: LINPACK Users' Guide, by J. J. Dongarra, C. B. Moler,
	 *     J. R. Bunch, and G. W. Stewart, publ by Soc. for Indust. and Appl.
	 *     Math, Philadelphia, 1979.
	 *     Adapted for the JPL Math77 library by C. L. Lawson, JPL, Aug 1987.
	 *     ------------------------------------------------------------------
	 *                    Subroutine arguments
	 *
	 *     A(,)  [inout]  On entry contains the N by N matrix A.
	 *           On return contains the LU factorization of A as computed by
	 *           LINPACK subroutines.
	 *
	 *     LDA  [in]  Leading dimensioning parameter for the array A(,).
	 *           Require LDA .ge. N.
	 *
	 *     N  [in]  The order of the matrix A and number of rows in the
	 *           matrices B and X.
	 *
	 *     B(,)  [inout]  On entry contains the N by NB matrix, B. The array
	 *           B() could be a singly subscripted array if NB .eq. 1.
	 *           On return, if RCOND .ne. ZERO, B() will contain the N by NB
	 *           solution matrix, X.   If RCOND .eq. ZERO the solution will
	 *           not be computed and B() will be unaltered.
	 *
	 *     LDB  [in]  Leading dimensioning parameter for the array B(,).
	 *           Require LDB .ge. N.
	 *
	 *     NB  [in]  Number of columns in the matrices B and X.  If NB .lt. 1
	 *           the matrix, A, will be factored but no reference will be
	 *           made to the array B(,).
	 *
	 *     IPVT()  [out]  Integer array of length at least N.  On return will
	 *           contain a record of the row interchanges done during
	 *           factorization of A.
	 *
	 *     RCOND  [out]  On return contains an estimate of the reciprocal of
	 *           the condition number of the given matrix, A.  Will be in the
	 *           range from zero to one.  Zero indicates an exactly singular
	 *           matrix.  A larger RCOND indicates a better conditioned
	 *           matrix.  If RCOND .eq. ZERO, the solution X will not be
	 *           computed.
	 *
	 *     Z()  [scratch]  Array of length at least N.  Used as work space.
	 *     ------------------------------------------------------------------
	 *     Subroutines called: SGECO, SGESLD
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------
	 *                                    Compute LU factorization of A
	 *                                and compute recip. cond. no. of A. */
	sgeco( a, lda, n, ipvt, rcond, z );
	if (*rcond == ZERO)
		return;
	/*                                    Solve equations. */
	for (j = 1; j <= nb; j++)
	{
		sgesld( a, lda, n, ipvt, &B(j - 1,0) );
	}
	return;
#undef	B
#undef	A
} /* end of function */
 
