/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:09 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "sdasnm.h"
#include <float.h>
#include <stdlib.h>
float /*FUNCTION*/ sdasnm(
long neq,
float v[],
float wt[],
float rwork[],
long iwork[])
{
	long int _l0, _l1, i, l;
	float g, h, sdasnm_v, sum, t, vmax;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	long *const Iwork = &iwork[0] - 1;
	float *const Rwork = &rwork[0] - 1;
	float *const V = &v[0] - 1;
	float *const Wt = &wt[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 2006, Math a la Carte, Inc.
	 *>> 2003-03-06 sdasnm Hanson changed norm computation to use reciprocals
	 *>> 2001-11-23 sdasnm Krogh  Changed many names per library conventions.
	 *>> 2001-11-04 sdasnm Krogh  Fixes for F77 and conversion to single
	 *>> 2001-11-01 sdasnm Hanson Provide code to Math a la Carte.
	 *--S replaces "?": ?DASNM, ?DASLX
	 *      IMPLICIT NONE
	 ****BEGIN PROLOGUE  SDASNM
	 ****SUBSIDIARY
	 ****PURPOSE  Compute vector norm for SDASLX.
	 ****LIBRARY   SLATEC (SDASLX)
	 ****TYPE      DOUBLE PRECISION (SDASNM-S, SDASNM-D)
	 ****AUTHOR  Petzold, Linda R., (LLNL)
	 ****DESCRIPTION
	 * ----------------------------------------------------------------------
	 *     THIS FUNCTION ROUTINE COMPUTES THE WEIGHTED
	 *     ROOT-MEAN-SQUARE NORM OF THE VECTOR OF LENGTH
	 *     NEQ CONTAINED IN THE ARRAY V,WITH WEIGHTS
	 *     CONTAINED IN THE ARRAY WT OF LENGTH NEQ.
	 *        SDASNM=SQRT((1/NEQ)*SUM(V(I)/WT(I))**2)
	 * ----------------------------------------------------------------------
	 ****ROUTINES CALLED  (NONE)
	 ****REVISION HISTORY  (YYMMDD)
	 *   830315  DATE WRITTEN
	 *   901009  Finished conversion to SLATEC 4.0 format (F.N.Fritsch)
	 *   901019  Merged changes made by C. Ulrich with SLATEC 4.0 format.
	 *   901026  Added explicit declarations for all variables and minor
	 *           cosmetic changes to prologue.  (FNF)
	 ****END PROLOGUE  SDASNM
	 * */
 
 
	/****FIRST EXECUTABLE STATEMENT  SDASNM */
	h = sqrtf( sqrtf( FLT_MAX ) );
	g = FLT_MIN/FLT_EPSILON;
	sum = 0.e0;
	vmax = 0.e0;
	for (i = 1; i <= neq; i++)
	{
		t = fabsf( V[i]*Wt[i] );
		/* If a component will have a square .gt. sqrt(huge) then
		 * shift to a scaled version of the norm. */
		if (t > h)
			goto L_110;
		sum += SQ(t);
		vmax = fmaxf( vmax, t );
 
	}
	/* May have a damaging underflow here.  If vmax = 0 then
	 * vector was flat zero.  If sum of squares is .le. tiny/epsilon
	 * then underflows (set to zero) may hurt accuracy.  So
	 * shift to a scaled version of the norm. */
	i = neq + 1;
	if (sum <= g && vmax > 0.e0)
		goto L_110;
	sdasnm_v = sqrtf( sum/neq );
	return( sdasnm_v );
 
L_110:
	;
	sdasnm_v = 0.0e0;
 
	/* Can start loop at I since the first I-1 components have
	 * been scanned for the max abs already. */
	for (l = i; l <= neq; l++)
	{
		if (fabsf( V[l]*Wt[l] ) > vmax)
			vmax = fabsf( V[l]*Wt[l] );
	}
	if (vmax <= 0.0e0)
		goto L_30;
	sum = 0.0e0;
	for (i = 1; i <= neq; i++)
	{
		sum += powif((V[i]*Wt[i])/vmax,2);
	}
	sdasnm_v = vmax*sqrtf( sum/neq );
L_30:
	;
	return( sdasnm_v );
	/* -----END OF FUNCTION SDASNM------ */
} /* end of function */
 
