/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:09 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "scshmm.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	ZP1	1.69800461894792e-02
#define	ZP2	1.77943488030894e-04
#define	ZP3	5.59297116264720e-07
#define	ZQ1	(-1.63532871439181e-02*24.0e0)
#define	ZQ2	(1.27814964403863e-04*24.0e0)
#define	ZQ3	(-5.80858944138663e-07*24.0e0)
#define	ZQ4	(1.33412535492375e-09*24.0e0)
		/* end of PARAMETER translations */
 
float /*FUNCTION*/ scshmm(
float x)
{
	float scshmm_v, xs;
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-10-20 SCSHMM Krogh  Changes to use M77CON
	 *>> 1993-05-07 SCSHMM WVSnyder JPL Initial code
	 *
	 *     Compute cosh(x) - 1 - x**2 using a rational approximation when
	 *     abs(x) is less than 2.7, else use the Fortran intrinsic function.
	 *
	 *--S replaces "?": ?CSHMM */
	/*     DATA ZP3/5.59297116264720E-07/,
	 *    *     ZP2/1.77943488030894E-04/,
	 *    *     ZP1/1.69800461894792E-02/,
	 *    *     ZQ4/1.33412535492375E-09/,
	 *    *     ZQ3/-5.80858944138663E-07/,
	 *    *     ZQ2/1.27814964403863E-04/,
	 *    *     ZQ1/-1.63532871439181E-02/ */
	xs = x*x;
	if (xs < 7.29e0)
	{
		scshmm_v = ((((ZP3*xs + ZP2)*xs + ZP1)*xs + 1.0e0)*xs*xs)/
		 ((((ZQ4*xs + ZQ3)*xs + ZQ2)*xs + ZQ1)*xs + 24.0e0);
	}
	else
	{
		scshmm_v = coshf( x ) - 1.0e0 - 0.5e0*xs;
	}
	return( scshmm_v );
} /* end of function */
 
