/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:45 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "scpdrv.h"
#include <stdlib.h>
void /*FUNCTION*/ scpdrv(
float c[],
long nc,
float d[],
long *nd)
{
	long int j, k;
	float d1, d2, fac;
	static float zero = 0.e0;
	static float half = .5e0;
	static float two = 2.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const C = &c[0] - 1;
	float *const D = &d[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-11-11 SCPDRV Krogh   Declared all vars.
	 *>> 1994-10-20 SCPDRV Krogh  Changes to use M77CON
	 *>> 1987-12-09 SCPDRV Lawson  Initial code.
	 *--S replaces "?": ?CPDRV */
 
	/*     INTEGRATION OF FINITE CHEBYSHEV SERIES
	 *     C.L.LAWSON, JPL, 1973 JULY 19
	 *
	 *     (C(I),I=1,2)       SCALE FACTORS .
	 *     C(I+2),I=1,NC+1    COEFS OF CHEBY SERIES .
	 *     NC                 DEGREE OF CHEBY SERIES .
	 *     (D(I),I=1,2)       OUTPUT..  SCALE FACTORS .
	 *     (D(I+2),I=1,ND+1)  OUTPUT..  COEFS DEFINING DIFFERENTIATED
	 *                                  SERIES .
	 *     ND                 OUTPUT..  DEGREE OF SERIES
	 * */
	if (nc < 0)
	{
		ierm1( "SCPDRV", 1, 0, "REQUIRE NC .GE. 0", "NC", nc, '.' );
	}
	else
	{
		D[1] = C[1];
		D[2] = C[2];
		if (nc == 0)
		{
			*nd = 0;
			D[3] = zero;
			return;
		}
		d2 = zero;
		*nd = nc - 1;
		if (*nd != 0)
		{
			d1 = zero;
			fac = 2*nc;
			for (j = 1; j <= *nd; j++)
			{
				D[*nd + 4 - j] = fac*C[*nd + 5 - j] + d2;
				d2 = d1;
				d1 = D[*nd + 4 - j];
				fac -= two;
			}
		}
		D[3] = C[4] + d2*half;
		for (k = 1; k <= nc; k++)
		{
			D[k + 2] /= D[2];
		}
	}
	return;
} /* end of function */
 
