/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:32:04 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "scdnml.h"
#include <float.h>
#include <stdlib.h>
		/* PARAMETER translations */
#define	RSQT2	0.707106781186547524400844362104849039284836e0
		/* end of PARAMETER translations */
 
float /*FUNCTION*/ scdnml(
float x,
float mu,
float sigma)
{
	long int _l0;
	float s, scdnml_v, u;
	static float big = -1.0e0;
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1998-10-29 SCDNML Krogh  Moved external statement up for mangle.
	 *>> 1994-10-20 SCDNML Krogh  Changes to use M77CON
	 *>> 1994-08-05 SCDNML WV Snyder
	 *
	 *     Compute the Cumulative Distribution Function for the Normal
	 *     (Gaussian) distribution, g(x;mu,sigma).  This is given in terms of
	 *     erf by g(x;mu,sigma) = (1 + erf((x-mu) / (sqrt(2)*sigma)) ) / 2 =
	 *     1 - erfc((x-mu) / (sqrt(2)*sigma)) / 2.  To avoid cancellation
	 *     error when (X-MU) < 0, substitute erfc(z) = 2 - erfc(-z) in the
	 *     second expression above to get g(-x;mu,sigma) = erfc((mu-x) /
	 *     (sqrt(2)*sigma)) / 2.  This also works well when (X-MU) >= 0.
	 * */
	/*--S replaces "?": ?CDNML, ?ERFC */
	/*     BIG is the largest representable number.
	 *     RSQT2 = 1.0 / sqrt(2.0) */
 
	if (big < 0.0e0)
		big = FLT_MAX;
	u = (mu - x)*RSQT2;
	s = fabsf( sigma );
	if (s < 1.0e0)
	{
		if (u > s*big)
		{
			scdnml_v = 1.0e0;
			return( scdnml_v );
		}
	}
	scdnml_v = 0.5e0*serfc( u/s );
	return( scdnml_v );
} /* end of function */
 
