/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:08 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "scabs.h"
#include <stdlib.h>
/*++ Replace "SCABS" = .Y.//.N.//"ABS" */
		/* PARAMETER translations */
#define	ONE	1.0e0
#define	ZERO	0.0e0
		/* end of PARAMETER translations */
 
float /*FUNCTION*/ scabs(
float z[])
{
	float a, b, scabs_v;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const Z = &z[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1995-10-30 SCABS  Krogh   Fixed so M77CON can get S.P. for C conv.
	 *>> 1987-12-07 SCABS  Lawson  Initial code.
	 *--C replaces "?":
	 *
	 *     Returns sqrt(Z(1)**2 + Z(2)**2)
	 *     Lawson and Chiu, JPL, Oct 1987
	 * */
 
	a = fabsf( Z[1] );
	b = fabsf( Z[2] );
	if (a > b)
	{
		scabs_v = a*sqrtf( ONE + powif(b/a,2) );
	}
	else if (b != ZERO)
	{
		scabs_v = b*sqrtf( ONE + powif(a/b,2) );
	}
	else
	{
		scabs_v = ZERO;
	}
	return( scabs_v );
} /* end of function */
 
