/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:32:07 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "sbesy0.h"
#include <float.h>
#include <stdlib.h>
float /*FUNCTION*/ sbesy0(
float x)
{
	long int _l0;
	float ampl, sbesy0_v, theta, y;
	static float by0cs[19]={-.1127783939286557321793980546028e-1,-.1283452375604203460480884531838e0,
	 -.1043788479979424936581762276618e0,.2366274918396969540924159264613e-1,
	 -.2090391647700486239196223950342e-2,.1039754539390572520999246576381e-3,
	 -.3369747162423972096718775345037e-5,.7729384267670667158521367216371e-7,
	 -.1324976772664259591443476068964e-8,.1764823261540452792100389363158e-10,
	 -.1881055071580196200602823012069e-12,.1641865485366149502792237185749e-14,
	 -.1195659438604606085745991006720e-16,.7377296297440185842494112426666e-19,
	 -.3906843476710437330740906666666e-21,.1795503664436157949829120000000e-23,
	 -.7229627125448010478933333333333e-26,.2571727931635168597333333333333e-28,
	 -.8141268814163694933333333333333e-31};
	static float twodpi = 0.636619772367581343075535053490057e0;
	static long nty0 = 0;
	static float xsml = 0.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const By0cs = &by0cs[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1996-03-30 SBESY0 Krogh  Added external statement.
	 *>> 1995-11-13 SBESY0 Krogh  Changes to simplify conversion to C.
	 *>> 1994-11-11 SBESY0 Krogh   Declared all vars.
	 *>> 1994-10-20 SBESY0 Krogh  Changes to use M77CON
	 *>> 1990-11-29 SBESY0 CLL
	 *>> 1985-08-02 SBESY0 Lawson  Initial code.
	 * JULY 1977 EDITION.  W. FULLERTON, C3, LOS ALAMOS SCIENTIFIC LAB.
	 * C.L.LAWSON & S.CHAN, JPL, 1984 FEB ADAPTED TO JPL MATH77 LIBRARY.
	 *     ------------------------------------------------------------------
	 *--S replaces "?": ?BESY0, ?BESJ0, ?BMP0, ?INITS, ?CSEVL, ?ERM1
	 *     ------------------------------------------------------------------ */
 
	/* SERIES FOR BY0        ON THE INTERVAL  0.          TO  1.60000E+01
	 *                                        WITH WEIGHTED ERROR   8.14E-32
	 *                                         LOG WEIGHTED ERROR  31.09
	 *                               SIGNIFICANT FIGURES REQUIRED  30.31
	 *                                    DECIMAL PLACES REQUIRED  31.73
	 * */
 
 
	/*     ------------------------------------------------------------------ */
	if (nty0 == 0)
	{
		sinits( by0cs, 19, 0.1e0*FLT_EPSILON/FLT_RADIX, &nty0 );
		xsml = sqrtf( 4.0e0*FLT_EPSILON/FLT_RADIX );
	}
 
	if (x <= 0.e0)
	{
		sbesy0_v = 0.e0;
		serm1( "SBESY0", 1, 0, "X IS ZERO OR NEGATIVE", "X", x, '.' );
	}
	else if (x <= 4.e0)
	{
		if (x <= xsml)
		{
			y = 0.e0;
		}
		else
		{
			y = x*x;
		}
		sbesy0_v = twodpi*logf( 0.5e0*x )*sbesj0( x ) + .375e0 + scsevl( .125e0*
		 y - 1.e0, by0cs, nty0 );
	}
	else
	{
		sbmp0( x, &ampl, &theta );
		sbesy0_v = ampl*sinf( theta );
	}
 
	return( sbesy0_v );
 
} /* end of function */
 
