/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:07 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "idsta1.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	ZERO	0.0e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ idsta1(
long itab[],
long ni,
long istats[],
double xstats[],
long ihist[],
long ilow,
long ncells)
{
	long int i, index, ival, j, ncount, nm1;
	double delta, prev, sumsq, term, x;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	long *const Ihist = &ihist[0] - 1;
	long *const Istats = &istats[0] - 1;
	long *const Itab = &itab[0] - 1;
	double *const Xstats = &xstats[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 2000-12-01 IDSTA1 Krogh Removed unused parameter ONE.
	 *>> 1994-10-20 IDSTA1 Krogh Changes to use M77CON
	 *>> 1994-06-22 IDSTA1 CLL  Changed name to I[D/S]STA1.
	 *>> 1989-10-20 CLL
	 *>> 1987-05-01 ISTAT1 Lawson  Initial code.
	 *
	 *        This subr computes basic statistics for values of an integer
	 *     variable, say IVAL, storing the statistics as follows:
	 *
	 *             ISTATS(1) = Total count
	 *             ISTATS(2) = Min
	 *             ISTATS(3) = Max
	 *
	 *             XSTATS(1) = Mean
	 *             XSTATS(2) = Standard deviation
	 *
	 *     This subr also accumulates counts in IHIST() to develop a
	 *     histogram of values of IVAL.
	 *
	 *        The data to be treated is given in ITAB(1:NI).  If the
	 *     value of ISTATS(1) on entry is positive , say = NCOUNT, it is
	 *     assumed that NCOUNT data values have been processed previously
	 *     and results from that processing are in IHIST(), ISTATS(),
	 *     and XSTATS().  These results will be updated to reflect the
	 *     additional set of NI values.
	 *
	 *        Alternatively, if ISTATS(1) is zero, the initial contents of
	 *     ISTATS(2:3), XSTATS(), and IHIST() will be ignored and results
	 *     will be computed just for the present data set ITAB(1:NI).
	 *
	 *        The user must specify the range of the histogram
	 *     by setting ILOW and NCELLS.
	 *        The cells IHIST(2) through IHIST(NCELLS-1) will
	 *     be used to count occurences of IVAL = ILOW, ILOW+1, ..
	 *     ILOW + NCELLS - 3.
	 *        The end cells, IHIST(1) and IHIST(NCELLS) will be used to
	 *     count occurences of X less than ILOW or greater than
	 *     ILOW + NCELLS - 3, respectively.
	 *
	 *     The counting cells are associated with values of IVAL as follows:
	 *
	 *          Value of IVAL                   Counting cell
	 *
	 *          (-Infinity, ILOW-1]              IHIST(1)
	 *          [ILOW, ILOW+NCELLS-3]            IHIST(IVAL-ILOW +2)
	 *          [ILOW+NCELLS-2, Infinity)        IHIST(NCELLS)
	 *
	 *        After use of this subroutine, the user can call
	 *     ISTAT2, as appropriate, to produce a
	 *     printer-plot of the histogram and print the statistics.
	 *
	 *        Remark:  It is more efficient to call this subroutine one
	 *     time giving it N points rather than calling it N times giving it
	 *     one point each time, but the results will be the same to within
	 *     arithmetic limitations either way.
	 *     ------------------------------------------------------------------
	 *                    Subroutine arguments
	 *
	 *     ITAB()  [in]  Array of NI values whose statistics are to be
	 *           computed.
	 *     NI    [in]  Number of values given in ITAB().
	 *           Require NI .ge. 1.
	 *     ISTATS(), XSTATS()  [inout]  Arrays of length 3 and 2
	 *           respectively, into which statistics are or
	 *           will be stored.  Initial value of ISTATS(1) must be positive
	 *           if IHIST(), ISTATS() and XSTATS() contain prior results that
	 *           are to be updated.  Otherwise the initial value of STATS(1)
	 *           must be zero.
	 *     IHIST()  [inout]  Integer array of length at least NCELLS into
	 *           which counts will be accumulated.
	 *     ILOW    [in]  Value whose occurrences will be counted in IHIST(2).
	 *     NCELLS  [in]  Total number of classification regions.
	 *           Require NCELLS .ge. 3.
	 *     ------------------------------------------------------------------
	 *     C. L. Lawson and S. Y. Chiu, JPL, Apr 1987.
	 *     1989-10-20 CLL Moved integer declaration earlier to avoid warning
	 *     msg from Cray compiler.
	 *     ------------------------------------------------------------------
	 *--D replaces "?": I?STA1
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	if (ni < 1)
		return;
	ncount = Istats[1];
	if (ncount == 0)
	{
		for (i = 1; i <= ncells; i++)
		{
			Ihist[i] = 0;
		}
		Istats[2] = Itab[1];
		Istats[3] = Istats[2];
		Xstats[1] = ZERO;
		sumsq = ZERO;
	}
	else
	{
		sumsq = (ncount - 1)*SQ(Xstats[2]);
	}
 
	for (j = 1; j <= ni; j++)
	{
		ival = Itab[j];
		x = ival;
		Istats[2] = min( ival, Istats[2] );
		Istats[3] = max( ival, Istats[3] );
		prev = ncount;
		ncount += 1;
		delta = x - Xstats[1];
		term = delta/ncount;
		Xstats[1] += term;
		sumsq += prev*delta*term;
 
		/*           .                         Begin: Tally in histogram. */
		index = ival - ilow + 2;
		if (index < 1)
		{
			Ihist[1] += 1;
		}
		else if (index > ncells)
		{
			Ihist[ncells] += 1;
		}
		else
		{
			Ihist[index] += 1;
		}
		/*           .                         End: Tally in histogram. */
	}
	Istats[1] = ncount;
	nm1 = ncount - 1;
	if (nm1 > 0)
	{
		Xstats[2] = sqrt( sumsq/nm1 );
	}
	else
	{
		Xstats[2] = ZERO;
	}
	return;
} /* end of function */
 
