/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:54 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dtrc2c.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	ZERO	0.0e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ dtrc2c(
double b[],
long nb,
double c1[],
double ytab[],
double yptab[])
{
	LOGICAL32 newseg;
	long int i, ib, ideriv, iseg, isegm1, mb, nseg;
	double p[4], sum;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const B = &b[0] - 1;
	double *const C1 = &c1[0] - 1;
	double *const P = &p[0] - 1;
	double *const Yptab = &yptab[0] - 1;
	double *const Ytab = &ytab[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-11-11 DTRC2C Krogh   Declared all vars.
	 *>> 1994-10-20 DTRC2C Krogh  Changes to use M77CON
	 *>> 1987-12-09 DTRC2C Lawson  Initial code.
	 *--D replaces "?": ?TRC2C, ?C2BAS
	 *          Given C1() containing coefficients relative to a
	 *     cubic B-spline basis, this subr computes and stores into
	 *     YTAB() and YPTAB()  respectively, the value and first derivative
	 *     of the spline curve at each nodal point given in B().
	 *     INPUT..
	 *     (B(I),I=1,NB)     PARTITION POINTS,INCLUDING ENDPOINTS
	 *     NB                NO. OF POINTS IN B().
	 *                       NO. OF SEGMENTS IS NSEG = NB-1
	 *     (C1(I),I=1,NB+2)   Coefficients relative to a cubic B-spline basis
	 *
	 *     OUTPUT..
	 *     (YTAB(i),i=1,NB) and (YPTAB(i),i=1,NB)
	 *                    Values of spline function and its first
	 *                    derivative at the points given in B().
	 *                    YTAB(2*j-1) = f(B(j),   YPTAB(2*j) = fprime(B(j)).
	 *     ------------------------------------------------------------------
	 *     Based on code written by Lawson, Hanson, Lang, and Campbell, JPL,
	 *     1968-1974.
	 *     Modified July 1984 and July 1987 by C. L. Lawson, JPL, for
	 *     inclusion in the MATH 77 library.
	 *     ------------------------------------------------------------------
	 *     Subprogram referenced:  DC2BAS
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	mb = nb;
	nseg = mb - 1;
	for (ib = 1; ib <= mb; ib++)
	{
		iseg = min( nseg, ib );
		isegm1 = iseg - 1;
		newseg = TRUE;
		for (ideriv = 0; ideriv <= 1; ideriv++)
		{
			dc2bas( B[ib], ideriv, iseg, &newseg, b, nb, p );
			sum = ZERO;
			for (i = 1; i <= 4; i++)
			{
				sum += C1[isegm1 + i]*P[i];
			}
			if (ideriv == 0)
			{
				Ytab[ib] = sum;
			}
			else
			{
				Yptab[ib] = sum;
			}
		}
	}
	return;
} /* end of function */
 
