/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:57 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dsnpxx.h"
#include <float.h>
#include <stdlib.h>
double /*FUNCTION*/ dsnpxx(
double x)
{
	long int _l0, j, k, n;
	double dsnpxx_v, f, g;
	static double bigx = -1.0e0;
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *--D replaces "?": ?SNPXX, ?COSPX, ?SINPX
	 *>> 2001-07-16 DSNPXX Krogh  Change -1.0 to -1.d0.
	 *>> 1998-10-29 DSNPXX Krogh  Moved external statement up for mangle.
	 *>> 1996-01-08 DSNPXX WV Snyder Original code */
	/* SIN(PI * X * X / 2) carefully to avoid loss of precision for large X */
	/* DSINPX is used to compute SIN(PI * X) */
	/* BIGX = 1 / round-off = biggest integer exactly representable by F.P.
	 *    If X > BIGX then to the working precision x**2 is an integer (which
	 *    we assume to be a multiple of four), so sin(pi/2 * x**2) = 0.
	 * N = [X], and later [K F]
	 * F = X - N = fractional part of X
	 * K = [ N / 2 ]
	 * J = N mod 2
	 * G = K F - M = fractional part of K F */
	if (bigx < 0.0e0)
		bigx = 1.0e0/DBL_EPSILON;
	f = fabs( x );
	if (f > bigx)
	{
		/*       Assume x is an even integer. */
		dsnpxx_v = 0.0e0;
		return( dsnpxx_v );
	}
	n = f;
	f -= n;
	k = n/2;
	j = n%2;
	g = k*f;
	n = g;
	g -= n;
	if (j == 0)
	{
		dsnpxx_v = dsinpx( 0.5e0*f*f + g + g );
	}
	else
	{
		dsnpxx_v = dcospx( 0.5e0*f*f + f + g + g );
	}
	return( dsnpxx_v );
} /* end of function */
 
