/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:06 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dsdif.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	ZERO	0.0e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ dsdif(
long k,
long n,
double t[],
double bcoef[],
long nderiv,
double *bdif)
{
#define BDIF(I_,J_)	(*(bdif+(I_)*(n)+(J_)))
	long int i, id, kmid;
	double diff, fkmid;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Bcoef = &bcoef[0] - 1;
	double *const T = &t[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-10-20 DSDIF Krogh  Changes to use M77CON
	 *>> 1992-11-02 DSDIF C. L. Lawson, JPL
	 *>> 1988-03-16 C. L. Lawson, JPL
	 *
	 *     Constructs a divided difference table in BDIF(,), preparatory to
	 *     derivative calculation.
	 *     The subroutine, BSPLPP, given on pp. 140-141 of
	 *     A PRACTICAL GUIDE TO SPLINES by Carl De Boor, Springer-Verlag,
	 *     1978, has been recoded as separate subroutines: DSTOT (or DSTOP)
	 *     calling DSDIF and DSVALA.  This subroutine has the functionality
	 *     of lines 57-71 of BSPLPP in the book.
	 *     ------------------------------------------------------------------
	 *--D replaces "?": ?SDIF
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	for (i = 1; i <= n; i++)
	{
		BDIF(0,i - 1) = Bcoef[i];
	}
	kmid = k;
	for (id = 2; id <= (nderiv + 1); id++)
	{
		kmid -= 1;
		fkmid = (double)( kmid );
		for (i = id; i <= n; i++)
		{
			diff = T[i + kmid] - T[i];
			if (diff != ZERO)
			{
				BDIF(id - 1,i - 1) = fkmid*(BDIF(id - 2,i - 1) - BDIF(id - 2,i - 2))/
				 diff;
			}
			else
			{
				BDIF(id - 1,i - 1) = ZERO;
			}
		}
	}
	return;
#undef	BDIF
} /* end of function */
 
