/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:42 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dmpdrv.h"
#include <stdlib.h>
void /*FUNCTION*/ dmpdrv(
double c[],
long nc,
double d[],
long *nd)
{
	long int i, ncp2;
	double fac;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const C = &c[0] - 1;
	double *const D = &d[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-10-20 DMPDRV Krogh  Changes to use M77CON
	 *>> 1987-12-09 DMPDRV Lawson  Initial code.
	 *     DERIVATIVE OF POLYNOMIAL REPRESENTED BY COEFFS REL TO THE
	 *     MONOMIAL BASIS INCLUDING A LINEAR TRANSFORMATION OF THE
	 *     ARGUMENT.
	 *     C.L.LAWSON, JPL, 1973 DEC 6
	 *
	 *     (C(I),I=1,2)       SCALE FACTORS
	 *     (C(I+2),I=1,NA+1)  COEFS OF POLY
	 *     NC                 DEGREE OF POLY
	 *     (D(I),I=1,2)       OUTPUT..  SCALE FACTORS
	 *     (D(I+2),I=1,ND+1)OUTPUT..COEFSOFDIFFERENTIATED
	 *                                  POLY
	 *     ND                 OUTPUT..  DEGREE OF POLY
	 *     -----------------------------------------------------------------
	 *--D replaces "?": ?MPDRV
	 *     Both versions use IERM1
	 *     ----------------------------------------------------------------- */
	/*     ----------------------------------------------------------------- */
	if (nc < 0)
	{
		ierm1( "DMPDRV", 1, 0, "REQUIRE NC .GE. 0", "NC", nc, '.' );
	}
	else
	{
		D[1] = C[1];
		D[2] = C[2];
		if (nc == 0)
		{
			*nd = 0;
			D[3] = 0.0e0;
		}
		else
		{
			ncp2 = nc + 2;
			*nd = ncp2 - 3;
			fac = 0.0e0;
			for (i = 3; i <= ncp2; i++)
			{
				fac += 1.0e0;
				D[i] = C[i + 1]*fac/D[2];
			}
		}
	}
	return;
} /* end of function */
 
