/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:05 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dlasum.h"
#include <stdlib.h>
void /*FUNCTION*/ dlasum(
double x,
long n,
double a[],
double *sum)
{
	long int k;
	double b, b1, b2, c1, c2, c3;
	static double zero = 0.e0;
	static double one = 1.e0;
	static double two = 2.e0;
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-10-20 DLASUM Krogh  Changes to use M77CON
	 *>> 1994-04-20 DLASUM CLL  Edited to make DP & SP files similar.
	 *>> 1992-03-13 DLASUM FTK  Removed implicit statements.
	 *>> 1985-08-02 DLASUM Lawson  Initial code.
	 *
	 *     THIS SUBROUTINE EVALUATES THE SUM OF
	 *          A(J) * L(J) FOR J = 0,...,N,
	 *     WHERE L(J)'S  ARE LAGUERRE POLYNOMIALS OF DEGREE J.
	 *
	 *      THE RECURSION FORMULA IS :
	 *      B(K) = B(K+1)*(2*K+1-X)/(K+1)-B(K+2)*(K+1)/(K+2)+A(K)
	 *
	 *      C.L.LAWSON & S.CHAN,JPL,1983 JUNE 9.
	 *
	 *     -------------------------------------------------------------
	 *     SUBROUTINE ARGUMENTS
	 *     --------------------
	 *     X     ARGUMENT OF LAG POLYS, X SHOULD BE NON-NEGATIVE.
	 *     N     SUM IS TO INCLUDE LAGUERRE POLYS OF DEGREE ZERO
	 *           THRU N.
	 *     A()   A(0),...,A(N) CONTAIN COEFFS TO BE USED IN
	 *           FORMING THE SUM.
	 *     SUM   SUM OF COMBINATION
	 *
	 *     -------------------------------------------------------------
	 *--D replaces "?": ?LASUM
	 *     ------------------------------------------------------------- */
	/*     ------------------------------------------------------------- */
	if (n < 0)
	{
		*sum = zero;
		return;
	}
 
	c1 = n + 1;
	c3 = c1 + c1 - one;
	b1 = zero;
	b = a[n];
 
	for (k = n - 1; k >= 0; k--)
	{
 
		/*     C1 = K + 1, C3 = 2K + 1
		 * */
		c2 = c1;
		c1 -= one;
		c3 -= two;
		b2 = b1;
		b1 = b;
		b = b1*(c3 - x)/c1 - b2*c1/c2 + a[k];
	}
	*sum = b;
	return;
} /* end of function */
 
