/* unfio.h  -   header for UNFormatted I/O 
                    by COBALT BLUE (TM)
          copyright Cobalt Blue, Inc., 1988 - 1992
                  ALL RIGHTS RESERVED
 */

#ifdef NOTDOS
#define MAX_UNFBUF	4096 /*32768*/
#else /* MSDOS assumed */
#define MAX_UNFBUF	4096
#endif

#if sparc || _IBMR2 || CRAY || hpuxpa || __sgi
#define ALIGN_UNF
#endif

#ifdef ALIGN_UNF
	/* 
	   Align ALL unformatted I/O objects on word boundaries (relative
	   to the begining or base pointer) to avoid runtime errors on
	   certain machines, (e.g., SUN/4, Sparcstation, IBM RS6000).

	   The macro should be present prior to reading or writing any of the
	   above objects to a local unformatted buffer.  The usage is:

	        ALIGN( next_ptr, beg_ptr );

	   The next_ptr is unchanged if presently on a word boundary, or is 
	   advanced to the next word boundary when not.

	   NOTE: If sharing unformatted files with a machine that aligns on
	   word boundaries, then both applications should align their unf.
	   I/O for consistency.
	 */
#	define ALIGN(n,b)	n = ( (n-(b))%ASIZ ? ((n-(b))/ASIZ + 1)*ASIZ + (b) : n )
#	if CRAY
#		define ASIZ 8	/* 64 bits per word */
#	else
#		define ASIZ	4	/* bytes per word, (4 is 32 bit word size) */
#	endif
#else
#	define ALIGN(n,b)
#endif

#ifdef PROTOTYPES
	                  /* UNFormatted scan functions */
	int fadvunf( FILE* );	/* advance to next unf'd record header */
		/* returns 0 if skipped, EOF for an error or EOF */
	int fscanunf( FILE*, char*, ... );	/* unf'd variable length record INput */
		/* returns,
		    the number of args read, (which may be zero),
		    -1 for a buffer memory allocation error	(1st call only),
		    -2 for a file ptr error
		 */ 
	int fseek_rd(FILE*,long,size_t,char*);	/* seek & read chars into buffer */
		/* returns,
			0 if successful
			-1 if seek error
			-2 if read error
		  NOTE: fseek_rd() is normally used in conjunction with sscanunf()
		  	when doing fixed record size unf'd I/O.
		 */
	size_t sscanunf(char*,char*,...);	/* unf'd INput from buffer */
		/* returns the number of chars read from the buffer */

	                 /* UNFormatted print functions */
	long fprtunf( FILE*, char*, ... );	/* unf'd variable length record OUTput */
		/* returns,
		    size of the record output (bytes) excluding the header & trailer,
		    -1 for a buffer memory allocation error	(1st call only),
		    -2 for a file ptr error
		    -3 for a write error
		 */
	int fseek_wrt(FILE*,long,size_t,char*);	/* seek & write buffer to a file */
		/* returns,
			0 if successful
			-1 if seek error
			-2 if write error
		  NOTE: fseek_wrt() is normally used in conjunction with sprtunf()
		  	when doing fixed record size unf'd I/O.
		 */
	int setprtunf( char*, size_t );	/* define & init the fprtunf() buffer */
		/* returns 0 if successfully initialized
		   NOTE: setprtunf() free's any prior allocated buffer, 
		         hence ONLY malloc'd buffers should be used! ! !
		 */
	size_t sprtunf(char*,char*,...);	/* unf'd OUTput to buffer */
		/* returns the number of chars written to the buffer */

#else

	int fadvunf();
	int fscanunf();
	int fseek_rd();
	size_t sscanunf();
	long fprtunf();
	int fseek_wrt();
	int setprtunf();
	size_t sprtunf();

#endif
