/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:19 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_ssvdrs s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_ssvdrs.h"
/*     program DRSSVDRS
 *>> 1996-06-25 DRSSVDRS   Krogh Changes for conversion to C.
 *>> 1996-05-28 DRSSVDRS   Krogh Added external statement.
 *>> 1994-10-19 DRSSVDRS   Krogh  Changes to use M77CON
 *>> 1992-03-18 DRSSVDRS   CLL Added "c" to "program" line above.
 *>> 1992-03-12 DRSSVDRS   CLL
 *     Demo driver for SSVDRS and SCOV3, Singular Value Decomposition
 *     and Covariance matrix.
 *
 *     The sample data was computed as
 *     y = 0.5 + 0.25 * sin(2*pi*x) + 0.125 * exp(-x)
 *     rounded to four decimal places.
 *     ------------------------------------------------------------------
 *--S replaces "?": DR?SVDRS, ?SVDRS, ?COV3, ?DOT, ?NRM2
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	MMAX	11
#define	NMAX	3
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int i, ierr, j, m, n;
	float a[NMAX][MMAX], b[MMAX], c[NMAX], dof, pi, rnorm, sing[NMAX],
	 stddev, var, work[2*NMAX];
	static float x[MMAX]={0.0e0,0.1e0,0.2e0,0.3e0,0.4e0,0.5e0,0.6e0,
	 0.7e0,0.8e0,0.9e0,1.0e0};
	static float y[MMAX]={0.6250e0,0.7601e0,0.8401e0,0.8304e0,0.7307e0,
	 0.5758e0,0.4217e0,0.3243e0,0.3184e0,0.4039e0,0.5460e0};
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const B = &b[0] - 1;
	float *const C = &c[0] - 1;
	float *const Sing = &sing[0] - 1;
	float *const Work = &work[0] - 1;
	float *const X = &x[0] - 1;
	float *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     ------------------------------------------------------------------ */
	m = MMAX;
	n = NMAX;
	printf(" DRSSVDRS..    Demo driver for SSVDRS and SCOV3.\n");
 
	pi = 4.0e0*atanf( 1.0e0 );
	for (i = 1; i <= m; i++)
	{
		a[0][i - 1] = 1.0e0;
		a[1][i - 1] = sinf( 2.0e0*pi*X[i] );
		a[2][i - 1] = expf( -X[i] );
		B[i] = Y[i];
	}
 
	ssvdrs( (float*)a, MMAX, m, n, b, MMAX, 1, sing, work );
 
	printf("\n Computed singular values:\n ");
	for (i = 1; i <= n; i++)
	{
		printf("%14.6g", Sing[i]);
	}
	printf("\n");
	printf("\n V matrix:\n");
	for (i = 1; i <= n; i++)
	{
		printf(" ");
		for (j = 1; j <= n; j++)
		{
			printf("%12.6f", a[j - 1][i - 1]);
		}
		printf("\n");
	}
 
	rnorm = snrm2( m - n, &B[n + 1], 1 );
	dof = m - n;
	var = SQ(rnorm)/dof;
	stddev = sqrtf( var );
	printf("\n Estimated Std. Dev. of data error =%10.6f\n", stddev);
 
	/*     Writing the singular value decomposition of A as
	 *              A = U * S * Transpose(V),
	 *     the solution of the least-squares problem A*c ~ b will be
	 *              c  = V * Inverse(S) *Transpose(U) * b.
	 *     We now have V in A(), S in SING(), and the product, Transpose(U)*b
	 *     in B().  So we can now compute c, as long as all singular values
	 *     are nonzero.
	 *     SING() contains the singular values as nonnegative
	 *     numbers in nonincreasing order, so we only need to test SING(N).
	 * */
	if (Sing[n] != 0.0e0)
	{
		for (i = 1; i <= n; i++)
		{
			B[i] /= Sing[i];
		}
		for (i = 1; i <= n; i++)
		{
			C[i] = sdot( n, &a[0][i - 1], MMAX, b, 1 );
		}
 
		printf(" Solution coefficients   =");
		for (j = 1; j <= n; j++)
		{
			printf("%10.6f", C[j]);
		}
		printf("\n");
	}
 
	/*                      Compute covariance matrix.
	 * */
	scov3( (float*)a, MMAX, n, sing, var, work, &ierr );
	printf("\n After SCOV3, IERR = %4ld\n", ierr);
	if (ierr == 0)
	{
		printf("\n Covariance matrix:\n");
		for (i = 1; i <= n; i++)
		{
			printf(" ");
			for (j = 1; j <= n; j++)
			{
				printf("%14.6g", a[j - 1][i - 1]);
			}
			printf("\n");
		}
	}
	exit(0);
} /* end of function */
 
