/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:17 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_snlsfb s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_snlsfb.h"
/*     program DRSNLSFB
 *>> 2001-05-24 DRSNLSFB Krogh Minor change for making .f90 version.
 *>> 1994-11-02 DRSNLSFB Krogh  Changes to use M77CON
 *>> 1994-09-14 DRSNLSFB CLL Set IV(OUTLEV) = 0 for comparing output.
 *>> 1992-02-03 CLL @ JPL
 *>> 1990-07-02 CLL @ JPL
 *>> 1990-06-27 CLL @ JPL
 *>> 1990-06-14 CLL @ JPL
 *>> 1990-04-05 CLL @ JPL
 *>> 1990-03-29 CLL @ JPL
 *     Demo driver for SNLSFB. A variant of the nonlinear LS code NL2SOL.
 *     SNLSFB solves the "separable" problem.
 *     SNLSFB handles bounds on the nonlinear variables.
 *     SNLSFB requires function values only.
 *     Note:  The expressions below set LIV and LV larger than
 *     necessary because the precise formulas cannot be written in a
 *     Fortran parameter statement.
 *     ------------------------------------------------------------------
 *--S replaces "?": DR?NLSFB, ?NLSFB, ?CALCA, ?IVSET
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	F	10
#define	LIV	(122 + 2*MDIR + 7*MA + 2*MB + MB + 1 + 6*MA)
#define	LV	(105 + MDATA*(2*MB + 6 + MA) + (MB*(MB + 3))/2 + MA*(2*MA + 22))
#define	MA	2
#define	MB	5
#define	MDATA	30
#define	MDIR	4
#define	OUTLEV	19
#define	SOLPRT	22
#define	STATPR	23
#define	X0PRT	24
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int iterm, iv[LIV], ivar, j, na, nb, ndata, _i, _r;
	static long int ind[MA][MB + 1];
	float alf[MA], bet[MB], dof, v[LV];
	static float bnd[MA][2];
	static float ydata[MDATA]={1.700641e0,1.793512e0,1.838309e0,1.838416e0,
	 1.792204e0,1.700501e0,1.579804e0,1.426268e0,1.260724e0,1.084901e0,
	 0.917094e0,0.761920e0,0.627304e0,0.522146e0,0.446645e0,0.404920e0,
	 0.392033e0,0.409622e0,0.453045e0,0.510765e0,0.584554e0,0.663109e0,
	 0.747613e0,0.829439e0,0.908496e0,0.983178e0,1.051046e0,1.114072e0,
	 1.171746e0,1.227823e0};
	static int _aini = 1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const Alf = &alf[0] - 1;
	float *const Bet = &bet[0] - 1;
	long *const Iv = &iv[0] - 1;
	float *const V = &v[0] - 1;
	float *const Ydata = &ydata[0] - 1;
		/* end of OFFSET VECTORS */
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		for (j = 1; j <= 2; j++)
		{
			bnd[j - 1][0] = 5.0e0;
			}
		for (j = 1; j <= 2; j++)
		{
			bnd[j - 1][1] = 10.0e0;
			}
		{ static long _itmp0[] = {0,0,1,0,1,0,0,1,0,1,0,0};
		for (iterm = 1, _r = 0; iterm <= 6; iterm++)
		{
			for (ivar = 1; ivar <= 2; ivar++)
			{
				ind[ivar - 1][iterm - 1] = _itmp0[_r++];
				}
			}
		}
		_aini = 0;
	}
 
	/*     ------------------------------------------------------------------ */
	ndata = MDATA;
	na = MA;
	nb = MB;
	Alf[1] = 5.0e0;
	Alf[2] = 10.0e0;
	Iv[1] = 0;
 
	printf(" Program DRSNLSFB.. Demo driver for SNLSFB.\n    A variant of NL2SOL.\n "
	   "   SNLSFB handles the Separable problem.\n "
	   "   SNLSFB requires function values but not the Jacobian.\n "
	   "   SNLSFB handles bounds on the nonlinear variables.\n  \n "
	   "Sample problem is a nonlinear curve fit to data.\n "
	   "Model function is B1 + B2 * cosf(A1*t) + B3 * sinf(A1*t) +\n "
	   "                       B4 * cosf(A2*t) + B5 * sinf(A2*t) + Noise\n "
	   "Data generated using\n (A1, A2, B1, ..., B5) = (6, 9, 1, 0.5, 0.4, 0.2, 0.1)\n "
	   "and Gaussian noise with mean 0 and\n sample standard deviation 0.001\n  \n");
 
	sivset( 1, iv, LIV, LV, v );
	Iv[X0PRT] = 1;
	Iv[OUTLEV] = 0;
	Iv[STATPR] = 1;
	Iv[SOLPRT] = 1;
 
	snlsfb( ndata, na, nb, alf, bnd, bet, ydata, scalca, (long*)ind,
	 nb + 1, iv, LIV, LV, v );
 
	dof = max( ndata - na - nb, 1 );
	printf(" \n SIGFAC: sqrtf((2 * V(F))/DOF) =%12.4g\n", sqrtf( 2.0e0*V[F]/dof ));
	exit(0);
} /* end of function */
/*     ================================================================== */
void /*FUNCTION*/ scalca(
long ndata,
long na,
long nb,
float alf[],
long *ncount,
float *phi)
{
#define PHI(I_,J_)	(*(phi+(I_)*(ndata)+(J_)))
	long int i;
	float del, t;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const Alf = &alf[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*     Test case for separable nonlinear least squares computation.
	 *     Computes MDATA x NB matrix PHI as a function of the
	 *     nonlinear parameters ALF().
	 *     For J .le. NB the (I,J) term of PHI is the coefficient of the
	 *     linear coefficient B(J) in row I of the model.
	 *     In this example the model does not have a term that is not
	 *     multiplied by a linear coefficient.  If such a term is present
	 *     then PHI must have an (NB+1)st column to hold this term.
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	t = 0.0e0;
	del = 1.0e0/29.0e0;
	for (i = 1; i <= ndata; i++)
	{
		PHI(0,i - 1) = 1.0e0;
		PHI(1,i - 1) = cosf( Alf[1]*t );
		PHI(2,i - 1) = sinf( Alf[1]*t );
		PHI(3,i - 1) = cosf( Alf[2]*t );
		PHI(4,i - 1) = sinf( Alf[2]*t );
		t += del;
	}
	return;
#undef	PHI
} /* end of function */
 
