/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:13 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_dtcst s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_dtcst.h"
/*     program DRDTCST
 *>> 1996-06-05 DRDTCST Krogh Fixes for conversion to C.
 *>> 1996-05-28 DRDTCST Krogh Moved formats up.
 *>> 1994-10-19 DRDTCST Krogh  Changes to use M77CON
 *>> 1994-08-09 DRDTCST WVS Remove '0' from format
 *>> 1992-04-22 DRDTCST CAO commented program statement
 *>> 1989-05-08 DRDTCST FTK, CLL
 *>> 1989-05-04 DRDTCST FTK, CLL
 * Driver to demonstrate DTCST
 *     ------------------------------------------------------------------
 *--D replaces "?": DR?TCST, ?TCST
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	KSKIP	10
#define	M	6
#define	N	65
#define	ND	1
#define	ONE	1.e0
#define	PI	3.1415926535897932384e0
#define	ZERO	0.e0
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int k, ms;
	double cos1, deltao, deltat, f[65], ftrue, omega, s[32], sin1,
	 t;
	static double ttime = 10.e0;
	static long ma[1]={M};
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const F = &f[0] - 1;
	long *const Ma = &ma[0] - 1;
	double *const S = &s[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*      parameter (N = 2 ** M + 1) */
	/*     ------------------------------------------------------------------ */
	sin1 = sin( ONE );
	cos1 = cos( ONE );
	deltat = ttime/(double)( N - 1 );
	deltao = (double)( KSKIP )*(PI/ttime);
	t = ZERO;
	/*                 Compute (TTIME / 2 ) * F(T) */
	F[1] = ttime/PI;
	for (k = 2; k <= N; k++)
	{
		t += deltat;
		F[k] = ttime*sinh( t )/sinh( PI*t );
	}
 
	ms = 0;
	dtcst( f, "C", "A", ma, ND, &ms, s );
 
	omega = ZERO;
	printf("\n  K    OMEGA        COMPUTED         TRUE\n");
	for (k = 1; k <= N; k += KSKIP)
	{
		ftrue = sin1/(cosh( omega ) + cos1);
		printf(" %3ld%13.5e%15.7e%15.7e\n", k, omega, F[k], ftrue);
		omega += deltao;
	}
	exit(0);
} /* end of function */
 
