/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:12 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_dsfit s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_dsfit.h"
/*     program DRDSFIT
 *>> 1996-07-03 DRDSFIT Krogh Special code for C conversion.
 *>> 1996-06-19 DRDSFIT Krogh Changes in formats for C conversion.
 *>> 1996-05-28 DRDSFIT Krogh Added external & removed Fortran 90 syntax
 *>> 1994-10-19 DRDSFIT Krogh Changes to use M77CON
 *>> 1992-11-18 DRDSFIT CLL   Changed order of arguments in DSFIT.
 *>> 1992-10-29 C. L. Lawson, JPL
 *    Demonstration driver for DSFIT, DSVAL, DSQUAD, DSTOP, DPVAL, DPQUAD
 *     ------------------------------------------------------------------
 *--D replaces "?": DR?SFIT, ?SFIT, ?SVAL, ?SQUAD, ?STOP, ?PVAL, ?PQUAD
 *--&                 ?PRPL
 *     ------------------------------------------------------------------
 *++ Code for .C. is active */
   long int k;
		/* PARAMETER translations */
#define	KORDER	4
#define	LDW	10
#define	MPC	(NCOEF - KORDER + 1)
#define	NCOEF	8
#define	NT	(NCOEF + KORDER)
#define	NXY	12
		/* end of PARAMETER translations */
 
 
int main( )
{
	char image[32];
	long int i, ierr, npc, _i, _r;
	double bcoef[NCOEF], bdif[NCOEF*KORDER], pcoef[MPC*KORDER], sigfac,
	 w[KORDER + 1][LDW], xi[MPC + 1], yfit, z;
	static double sd[1];
	static double x[NXY]={2.e0,4.e0,6.e0,8.e0,10.e0,12.e0,14.e0,16.e0,
	 18.e0,20.e0,22.e0,24.e0};
	static double y[NXY]={2.2e0,4.0e0,5.0e0,4.6e0,2.8e0,2.7e0,3.8e0,
	 5.1e0,6.1e0,6.3e0,5.0e0,2.0e0};
	static double tknots[NT]={2.0e0,2.0e0,2.0e0,2.0e0,6.4e0,10.8e0,
	 15.2e0,19.6e0,24.0e0,24.0e0,24.0e0,24.0e0};
	static long nderiv = 0;
	static int _aini = 1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Bcoef = &bcoef[0] - 1;
	double *const Bdif = &bdif[0] - 1;
	double *const Pcoef = &pcoef[0] - 1;
	double *const Sd = &sd[0] - 1;
	double *const Tknots = &tknots[0] - 1;
	double *const X = &x[0] - 1;
	double *const Xi = &xi[0] - 1;
	double *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		Sd[1] = -1.0e0;
		_aini = 0;
	}
 
/*++ End */
	/*     ------------------------------------------------------------------ */
	printf(" DRDSFIT\n Demo driver for DSFIT, DSVAL, DSQUAD, DSTOP, DPVAL, DPQUAD\n");
	printf("\n   KORDER =%3d,  NCOEF =%3d\n", KORDER, NCOEF);
	/*++ Code for ~.C. is inactive
	 *      print'(''   TKNOTS() = '',4f10.5/(14x,4f10.5))',
	 *     *   (TKNOTS(I), I = 1, NT)
	 *++ Code for .C. is active */
     printf("\n   TKNOTS() = ");
     for (i = 1; i <= NT+3; i+=4){
        for (k = i; k <= min( i+3, NT ); k++)
           printf("%10.5f", Tknots[k]);
        if (i + 3 < NT) printf("\n              ");}
	dsfit( x, y, sd, NXY, KORDER, NCOEF, tknots, bcoef, &sigfac, &ierr,
	 LDW, (double*)w );
	/*++ End
	 *++ Code for ~.C. is inactive
	 *      print'(/'' After call to DSFIT:''/''   IERR ='',i5,
	 *     *  '',  SIGFAC ='', f10.5 //''   BCOEF() = '',
	 *     *  4f10.5/(13x,4f10.5))', IERR, SIGFAC, (BCOEF(I),I=1,NCOEF)
	 *++ Code for .C. is active */
     printf("\n After call to DSFIT:\n   IERR =%5ld,  SIGFAC ="
        "%10.5f\n\n   BCOEF() = ", ierr, sigfac);
     for (i = 1; i <= NCOEF+3; i+=4){
        for (k = i; k <= min( i+3, NCOEF ); k++)
           printf("%10.5f", Bcoef[k]);
        if (i + 3 < NCOEF) printf("\n             ");}
	printf("\n Evaluating fitted spline function using DSVAL:\n");
	/*++ End */
	printf("\n    I    X       Y       YFIT  R=Y-YFIT               YFIT\n\n");
 
	for (i = 1; i <= NXY; i++)
	{
		yfit = dsval( KORDER, NCOEF, tknots, bcoef, X[i], nderiv );
		dprpl( yfit, '*', (byte*)image, 31, 1.9e0, 6.3e0, TRUE );
		printf("   %2ld%6.0f%9.3f%9.3f%10.3f   %31.31s\n", i, X[i], Y[i], yfit, Y[i] - yfit,
		   image);
	}
 
	z = dsquad( KORDER, NCOEF, tknots, bcoef, 5.0e0, 20.0e0 );
	printf("\n Integral from 5.0  to 20.0 using DSQUAD:%12.5f\n", z);
 
	dstop( KORDER, NCOEF, tknots, bcoef, bdif, &npc, xi, pcoef );
	printf("\n Using DSTOP to convert from B-spline basis to power basis.\n");
	printf("        NPC =%3ld\n", npc);
	/*++ Code for ~.C. is inactive
	 *      print'(''       XI() = '',4f10.5/(14x,4f10.5))',(XI(I),I=1,NPC+1)
	 *      print'(''    PCOEF() = '',4f10.5/(14x,4f10.5))',
	 *     *   (PCOEF(I),I=1,NPC*KORDER)
	 *++ Code for .C. is active */
   printf("       XI() = ");
   for (i = 1; i <= (npc + 1); i+=4){
      for (k = i; k <= min( i+3, npc+1 ); k++)
           printf("%10.5f", Xi[k]);
      if (i <= npc) printf("\n              ");}
   printf("\n    PCOEF() = ");
   for (i = 1; i <= (npc*KORDER); i+=4){
      for (k = i; k <= min( i+3, npc*KORDER ); k++)
           printf("%10.5f", Pcoef[k]);
      if (i < npc*KORDER) printf("\n              ");}
	printf("\n Evaluating fitted spline function using DPVAL:\n");
	/*++ End */
	printf("\n    I    X       Y       YFIT  R=Y-YFIT               YFIT\n\n");
 
	for (i = 1; i <= NXY; i++)
	{
		yfit = dpval( KORDER, npc, xi, pcoef, X[i], nderiv );
		dprpl( yfit, '*', (byte*)image, 31, 1.9e0, 6.3e0, TRUE );
		printf("   %2ld%6.0f%9.3f%9.3f%10.3f   %31.31s\n", i, X[i], Y[i], yfit, Y[i] - yfit,
		   image);
	}
 
	z = dpquad( KORDER, npc, xi, pcoef, 5.0e0, 20.0e0 );
	printf("\n Integral from 5.0  to 20.0 using DPQUAD:%12.5f\n", z);
	exit(0);
} /* end of function */
 
