/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:32:07 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dbesy0.h"
#include <float.h>
#include <stdlib.h>
double /*FUNCTION*/ dbesy0(
double x)
{
	long int _l0;
	double ampl, dbesy0_v, theta, y;
	static double by0cs[19]={-.1127783939286557321793980546028e-1,
	 -.1283452375604203460480884531838e0,-.1043788479979424936581762276618e0,
	 .2366274918396969540924159264613e-1,-.2090391647700486239196223950342e-2,
	 .1039754539390572520999246576381e-3,-.3369747162423972096718775345037e-5,
	 .7729384267670667158521367216371e-7,-.1324976772664259591443476068964e-8,
	 .1764823261540452792100389363158e-10,-.1881055071580196200602823012069e-12,
	 .1641865485366149502792237185749e-14,-.1195659438604606085745991006720e-16,
	 .7377296297440185842494112426666e-19,-.3906843476710437330740906666666e-21,
	 .1795503664436157949829120000000e-23,-.7229627125448010478933333333333e-26,
	 .2571727931635168597333333333333e-28,-.8141268814163694933333333333333e-31};
	static double twodpi = 0.636619772367581343075535053490057e0;
	static long nty0 = 0;
	static double xsml = 0.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const By0cs = &by0cs[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1996-03-30 DBESY0 Krogh  Added external statement.
	 *>> 1995-11-13 DBESY0 Krogh  Changes to simplify conversion to C.
	 *>> 1994-11-11 DBESY0 Krogh   Declared all vars.
	 *>> 1994-10-20 DBESY0 Krogh  Changes to use M77CON
	 *>> 1990-11-29 DBESY0 CLL
	 *>> 1985-08-02 DBESY0 Lawson  Initial code.
	 * JULY 1977 EDITION.  W. FULLERTON, C3, LOS ALAMOS SCIENTIFIC LAB.
	 * C.L.LAWSON & S.CHAN, JPL, 1984 FEB ADAPTED TO JPL MATH77 LIBRARY.
	 *     ------------------------------------------------------------------
	 *--D replaces "?": ?BESY0, ?BESJ0, ?BMP0, ?INITS, ?CSEVL, ?ERM1
	 *     ------------------------------------------------------------------ */
 
	/* SERIES FOR BY0        ON THE INTERVAL  0.          TO  1.60000D+01
	 *                                        WITH WEIGHTED ERROR   8.14D-32
	 *                                         LOG WEIGHTED ERROR  31.09
	 *                               SIGNIFICANT FIGURES REQUIRED  30.31
	 *                                    DECIMAL PLACES REQUIRED  31.73
	 * */
 
 
	/*     ------------------------------------------------------------------ */
	if (nty0 == 0)
	{
		dinits( by0cs, 19, 0.1e0*DBL_EPSILON/FLT_RADIX, &nty0 );
		xsml = sqrt( 4.0e0*DBL_EPSILON/FLT_RADIX );
	}
 
	if (x <= 0.e0)
	{
		dbesy0_v = 0.e0;
		derm1( "DBESY0", 1, 0, "X IS ZERO OR NEGATIVE", "X", x, '.' );
	}
	else if (x <= 4.e0)
	{
		if (x <= xsml)
		{
			y = 0.e0;
		}
		else
		{
			y = x*x;
		}
		dbesy0_v = twodpi*log( 0.5e0*x )*dbesj0( x ) + .375e0 + dcsevl( .125e0*
		 y - 1.e0, by0cs, nty0 );
	}
	else
	{
		dbmp0( x, &ampl, &theta );
		dbesy0_v = ampl*sin( theta );
	}
 
	return( dbesy0_v );
 
} /* end of function */
 
