function p = symamdtree (S)
% SYMAMDTREE Symmetric approximate minimum degree permutation (SYMAMD),
%    followed by a symmetric elimination tree post-ordering (SYMETREE).
%    P = SYMAMDTREE (S), for a symmetric positive definite matrix S,
%    returns the permutation vector p such that S(p,p) tends to have a
%    sparser Cholesky factor than S.  Sometimes SYMAMD works well
%    for symmetric indefinite matrices too.  SYMAMD tends to be faster
%    than SYMMMD and tends to return a better ordering.
%    SYMAMD uses spparms ('wh_frac') to determine how to
%    treat dense rows and columns.
%
%    See also SYMAMD, COLAMD, COLAMDTREE, COLMMD, SYMMMD, SYMRCM, COLPERM.
%
%    Authors:  Stefan I. Larimore and Timothy A. Davis, University of Florida,
%    (davis@cise.ufl.edu); in collaboration with John Gilbert, Xerox PARC, and
%    Esmond Ng, Oak Ridge National Laboratory.  This work was supported by the
%    National Science Foundation, under grants DMS-9504974 and DMS-9803599.
%    COLAMD and SYMAMD are available at http://www.cise.ufl.edu/~davis/colamd.

%    Tested under Matlab 5.2.0.3084, using Solaris 2.6.  August 3, 1998.

%-------------------------------------------------------------------------------
% perform the symamd ordering:
%-------------------------------------------------------------------------------

p = symmmd (S) ;

%-------------------------------------------------------------------------------
% symmetric elimination tree post-ordering:
%-------------------------------------------------------------------------------

[ignore, q] = sparsfun ('symetree', S (p,p)) ;
p = p (q) ;

