function p = colamd (S)
% COLAMD Column approximate minimum degree permutation.
%    P = COLAMD (S) returns the column approximate minimum degree permutation
%    vector for the sparse matrix S.  For a non-symmetric matrix S, S (:,P)
%    tends to have sparser LU factors than S.  The Cholesky factorization of
%    S (:,P)' * S (:,P) also tends to be sparser than that of S'*S.  COLAMD
%    tends to be faster than COLMMD and tends to return a better ordering.
%
%    See also COLAMDTREE, SYMAMD, SYMAMDTREE, COLMMD, SYMMMD, SYMRCM, COLPERM.
%
%    Usage:  P = colamd (S)
%            P = colamd (S, knobs)
%            [P, stats] = colamd (S)
%            [P, stats] = colamd (S, knobs)
%
%    stats (1) and stats (2) are the number of dense rows and columns
%    ignored in COLAMD, and stats (3) is the number of garbage collections
%    performed.  knobs (1) and knobs (2) control how COLAMD ignores dense rows
%    and columns (similar to spparms ('wh_frac')).
%
%    Authors:  Stefan I. Larimore and Timothy A. Davis, University of Florida,
%    (davis@cise.ufl.edu); in collaboration with John Gilbert, Xerox PARC, and
%    Esmond Ng, Oak Ridge National Laboratory.  This work was supported by the
%    National Science Foundation, under grants DMS-9504974 and DMS-9803599.
%    COLAMD and SYMAMD are available at http://www.cise.ufl.edu/~davis/colamd.

%    Tested under Matlab 5.2.0.3084, using Solaris 2.6.  August 3, 1998.
%    This file is provided so that "help colamd" prints the above description.

help colamd
disp ('Warning!  Valid colamd mexFunction not found.  Using colmmd instead.') ;
p = colmmd (S) ;

