C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C     Initialization of trace modes (optional)
C================================================================
      subroutine trace_initializations(comm_context)

C     Local
C----
      integer buf_len(1),comm_context(*)
      integer buffer(30)

C----
C     Determine trace mode
C
C     This call is optional. The default behaviour is to do
C     what libraries usually do: keep silent and work.
C----
      call default_trace_modes(buffer,buf_len(1))
      call demo_read_trace_modes(buffer,buf_len(1),comm_context)
      call init_trace_modes(buffer,buf_len(1))

      return
      end
C================================================================
C     Initialization of the way the matrix is stored.
C================================================================
      subroutine problem_initializations(vec_inf,comm_context)

C     Arguments
C----
      integer vec_inf(*),comm_context(*)

C     Local
C----
      integer buf_len(1),buffer(30),
     >     fmt,fmt_spec,sym_store
      character*3 cbuffer

C----
C     Storage format and read/create matrix; first demo data
C----
      call default_problem_format(buffer,buf_len(1))
      call demo_default_problem_format(buffer(5+1),5+1,buf_len(1))
      call demo_read_problem_format(buffer,buf_len(1),cbuffer,
     >     comm_context)
      call set_demo_matrix_file(cbuffer)
      call demo_set_problem_format(buffer(5+1),5+1,buf_len(1))
      buf_len(1) = min(buf_len(1),5)

C     For the library
C----
      fmt = buffer(1)
      fmt_spec = buffer(2)
      sym_store = buffer(3)
      if (fmt.eq.3) then
         call set_compress_format(vec_inf,fmt_spec,sym_store)
      else if (fmt.eq.2) then
         call set_diag_format(vec_inf,sym_store)
      else if (fmt.eq.1) then
         call set_grid_format(vec_inf,fmt_spec,sym_store)
      endif

      return
      end
C================================================================
C     For matrices generated internally (at the moment
C     only 2d grids-based), get the values of the elliptic PDE
C================================================================
      subroutine pde_initialization(comm_context)

C     Local
C----
      integer ibuffer(30),nitems(1),ritems(1),
     >     comm_context
      double precision rbuffer(30)

C----
C     PDE parameters
C     (only necessary for internally generated test matrices)
C
C     3 integer items
C     buffer(1) : function number 0=Poisson 2=step function
C     buffer(2) : unsymmetry 0=no 1=yes
C     buffer(3) : indefiniteness 0=no 1=yes
C     9 real parameters
C     ddx / ddy : diffusion coefficients
C     vx / vy : convection coefficients
C     alpha : amount identity subtracted from diagonal
C     sx / tx : location / height of step in x direction
C     sy / ty : same for y
C----
      call default_pde_parameters
     >     (ibuffer,nitems(1),rbuffer,ritems(1))
      call demo_read_pde_parameters
     >     (ibuffer,nitems(1),rbuffer,ritems(1),comm_context)
      call set_pde_parameters
     >     (ibuffer,nitems(1),rbuffer,ritems(1))

      return
      end
C================================================================
C     Create the matrix
C
C     Most of the actions here are only for the demo code.
C     
C     Explanation of problem formats:
C     Grid format = 10*(vec_inf(1)/10).eq.10
C     Diagonal format = 10*(vec_inf(1)/10).eq.20
C     Compress format = 10*(vec_inf(1)/10).eq.30
C     Matrix source (demo only):
C     Matrix internally generated = mat_source.eq.1
C     Matrix externally loaded = mat_source.eq.2
C
C================================================================
      subroutine matrix_creation(matrix,leng_mat,
     >     mat_ptr,leng_mat_ptr, mat_idx,leng_mat_idx,
     >     vec_inf,leng_vec_inf,comm_context)

C     Arguments
C----
      integer leng_mat,leng_mat_ptr,leng_mat_idx, leng_vec_inf
      double precision matrix(leng_mat)
      integer mat_ptr(leng_mat_ptr),mat_idx(leng_mat_idx),
     >     vec_inf(leng_vec_inf),comm_context(*)

C     The problem format.
C----
      integer              mat_source,rhs_source
      common /demo_prbfmt/ mat_source,rhs_source

C     Functions
C----
      logical trace_setup,tracer_proc

C     Local
C----

C----
C     Internally generated grid matrix
C     For cprs matrix we simply dump this differently
C----
C     Divide the domain over the processors
C----
         if (tracer_proc()) call pt0('Internal Grid Matrix$')
         call demo_int_grid_mat(matrix,leng_mat,
     >        mat_ptr,vec_inf,leng_vec_inf,comm_context,trace_setup())


      return
      end
