C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C     
C     Matrix manipulation routines for a distributed memory computer
C     
C     For different matrix types, the vectors and matrices have
C     different structures. The interpretation of the data in a vector
C     array is determined by the `vec_inf' pointer array.
C     Here are the common elements in that array.
C     @(n_vectyp): a type identifier for the data format
C     vec_inf(2): the number of owned variables
C     vec_inf(3): the number of local variables
C     vec_inf(4): the number of global variables
C     (these first three are identical for uniprocessor formats)
C     vec_inf(5): the location of vector structure information
C     vec_inf(6): the location of vector embedding information
C     Further definition of embedding and structure is dependent
C     on the specific data structures. See the appropriate files.
C
C================================================================
C----------------------------------------------------------------
C     Problem format. About sparsity structure and such.
C----------------------------------------------------------------
      subroutine default_problem_format(buffer,nitems)

C     Arguments
C----
      integer buffer(*),nitems

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Functions
C----
      logical tracer_proc

      if (tracer_proc().and.log_channel_open) then
      write(logchn,*) 
     >     '-------------------------------------------------------'
      write(logchn,*) 
     >     '[1] Problem format: 1-20=grid, 21/2/3=compressed'
      write(logchn,*) '[2] If grid: space dimension;'
      write(logchn,*) '    Compressed format: 2=row 4=col 5=symmetric'
      write(logchn,*) '[4] Sparsity: (0=def) symmetric (1) unsymmetric'
      write(logchn,*) '[3] Storage: (0=def) unsymmetric 1=symmetric'
      write(logchn,*) '[5] Variables partitioning:'
      write(logchn,*) '    1=consecutive, 2=external function'
      write(logchn,*) '[6] Rhs: (1=def) unit (2) external'
      write(logchn,*) '[7] Mat: 1=internally generated 2=from file'
      endif

      nitems = 7
C     fmt : 2D
      buffer(1) = 10
C     compressed format
      buffer(2) = 2
C     symmetric storage
      buffer(3) = 0
C     symmetric sparsity
      buffer(4) = 1
C     partitioning
      buffer(5) = 3

      return
      end
C----------------------------------------------------------------
      subroutine set_demo_matrix_file(cbuffer)

C     Arguments
C----
      character*3 cbuffer

C     Name of the external matrix file
C----
      character*50 matnam
      common /inmatx/matnam
      integer matnam_len
      common /inmatxi/matnam_len

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

      matnam = '   .mat'
      matnam(1:3) = cbuffer(1:3)
      matnam_len = 7

      if (log_channel_open) then
         write(logchn,*) 'Name of matrix file:'
         write(logchn,*) '---- <',cbuffer,'>'
      endif

      return
      end
C----------------------------------------------------------------
      subroutine set_compress_format(vec_inf,spec,symm)

C     Arguments
C----
      integer vec_inf(*),spec,symm

      if (symm.eq.1) then
         vec_inf(1) = 30+5
      else
         vec_inf(1) = 30+spec
      endif

      return
      end
C----------------------------------------------------------------
      subroutine set_diag_format(vec_inf,symm)

C     Arguments
C----
      integer symm,vec_inf(*)

      vec_inf(1) = 20+symm

      return
      end
C----------------------------------------------------------------
      subroutine set_grid_format(vec_inf,dim,symm)

C     Arguments
C----
      integer dim,symm,vec_inf(*)

      vec_inf(1) = 10+2*dim+symm

      return
      end
C----------------------------------------------------------------
      subroutine dump_problem_format(vec_inf)

C     Arguments
C----
      integer vec_inf(*)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

      if (log_channel_open) then
         write(logchn,*) 'Format:',vec_inf(1)
         if (10*(vec_inf(1)/10).eq.10) then
            write(logchn,*) 'Grid dimension:',(vec_inf(1)-10)/2
         else if (10*(vec_inf(1)/10).eq.30) then
            write(logchn,*) 'Compress fmt:',vec_inf(1)-30
         endif
         if (mod(vec_inf(1),2).eq.1)
     >        write(logchn,*) '- symmetric storage'
      endif

      if (dmp_channel_open) then
         if (10*(vec_inf(1)/10).eq.10) call pd0('Format: g$')
         if (10*(vec_inf(1)/10).eq.20) call pd0('Format: d$')
         if (10*(vec_inf(1)/10).eq.30) then
            call pd0('Format: i$')
            call pd0('(harbo compression)$')
         endif
      endif

      return
      end
C----------------------------------------------------------------
      subroutine strange_matrix_fmt(vec_inf,txt)

C     Arguments
C----
      character*(*) txt
      integer vec_inf(*)

      call pe1i('Unknown matrix format$',vec_inf(1))
      call stop_connections(txt)

      return
      end
C----------------------------------------------------------------
      function problem_dimension(vec_inf)

C     Argument
C----
      integer problem_dimension,vec_inf(*)

      problem_dimension = 2

      return
      end
C----------------------------------------------------------------
      subroutine set_global_variables(vars,vec_inf)

C     Arguments
C----
      integer vars,vec_inf(*)

      call force_range(vars,1,0,'Tot #vars (set)$')
      vec_inf(4) = vars

      return
      end
C----------------------------------------------------------------
C     Dump matrix
C----------------------------------------------------------------
      subroutine dump_matrix(matrix,mat_ptr,mat_idx,vec_inf)
      
C     Arguments
C---- 
      integer mat_ptr(*),mat_idx(*),vec_inf(*)
      double precision matrix(*)
      
C     Functions
C----
      logical tracer_proc

      if (10*(vec_inf(1)/10).eq.10) then
         if (tracer_proc()) call pt0('Dumping ort matrix$')
         call dump_matx_grid(matrix,mat_ptr,vec_inf)
      else if (10*(vec_inf(1)/10).eq.20) then
         if (tracer_proc()) call pt0('Dumping diag matrix$')
         call dump_matx_diag(matrix,mat_ptr,vec_inf)
      else if (10*(vec_inf(1)/10).eq.30) then
         if (tracer_proc()) call pt0('Dumping crs matrix$')
         call dump_matx_cprs(matrix,mat_ptr,mat_idx,vec_inf)
      else
         call strange_matrix_fmt(vec_inf,'Dump Matrix$')
      endif
      
      return
      end
C----------------------------------------------------------------
C     Primitive dump vector routine; 
C     everything goes to the dump channel
C----------------------------------------------------------------
      subroutine dump_vector(x,vec_inf,txt,itxt)

C     Arguments
C----
      integer vec_inf(*),itxt
      double precision x(*)
      character*(*) txt

C     Local
C----
      integer bord

      if (10*(vec_inf(1)/10).eq.10) then
         bord = vec_inf(vec_inf(5))
         call dump_vector_g(x,
     >        1-bord,vec_inf(vec_inf(5)+2)+bord,
     >        1-bord,vec_inf(vec_inf(5)+2+1)+bord,
     >        vec_inf,
     >        1,vec_inf(vec_inf(5)+2),1,vec_inf(vec_inf(5)+2+1),
     >        txt,itxt)
      else if (10*(vec_inf(1)/10).eq.30) then
         call dump_vector_i(x, vec_inf, txt,itxt)
      else if (10*(vec_inf(1)/10).eq.20) then
         call dump_vector_d(x, vec_inf, txt,itxt)
      else
         call strange_matrix_fmt(vec_inf,'Dump vector$')
      endif

      return
      end
C----------------------------------------------------------------
      subroutine dump_vector_o(x,vec_inf,txt,itxt)

C     Arguments
C----
      integer vec_inf(*),itxt
      double precision x(*)
      character*(*) txt

      if (10*(vec_inf(1)/10).eq.10) then
         call dump_vector_g(x,
     >        1,vec_inf(vec_inf(5)+2),
     >        1,vec_inf(vec_inf(5)+2+1),
     >        vec_inf,
     >        1,vec_inf(vec_inf(5)+2),1,vec_inf(vec_inf(5)+2+1),
     >        txt,itxt)
      else if (10*(vec_inf(1)/10).eq.30) then
         call dump_vector_i(x, vec_inf, txt,itxt)
      else if (10*(vec_inf(1)/10).eq.20) then
         call dump_vector_od(x, vec_inf, txt,itxt)
      else
         call strange_matrix_fmt(vec_inf,'Dump vector$')
      endif

      return
      end
C----------------------------------------------------------------
      subroutine dump_border(x,vec_inf,txt,itxt)

C     Arguments
C----
      integer vec_inf(*),itxt
      double precision x(*)
      character*(*) txt

C     Local
C----
      integer bord

      if (10*(vec_inf(1)/10).eq.10) then
         bord = vec_inf(vec_inf(5))
         call dump_border_g(x,
     >        1-bord,vec_inf(vec_inf(5)+2)+bord,
     >        1-bord,vec_inf(vec_inf(5)+2+1)+bord,
     >        vec_inf,
     >        1,vec_inf(vec_inf(5)+2),1,vec_inf(vec_inf(5)+2+1),
     >        txt,itxt)
      else if (10*(vec_inf(1)/10).eq.30) then
         call dump_border_i(x, vec_inf, txt,itxt)
      endif

      return
      end
