C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.8                                       C
C     This file last generated 94/10/21                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
C     Set up info for 5point internally created matrix
C     locmat = location of matrix in memory array.
C----------------------------------------------------------------
      subroutine demo_get_grid_offsets(mat_ptr,vec_inf)
      
C     Arguments
C---- 
      integer mat_ptr(*),vec_inf(*)
      
C     Local
C---- 
      integer fivep_offsets(2,4), first_off,ndia
      data fivep_offsets/0,-1, -1,0, +1,0, 0,+1/
      
C     In the demo so far, only 2 space dimensions
C----
      mat_ptr(1) = 2

C     The number of diagonals depends on whether this is symmetric or not
C----
      if (mod(vec_inf(1),2).eq.1) then
         ndia = 2
         first_off = 3
      else
         ndia = 4
         first_off = 1
      endif
      mat_ptr(2) = ndia

      call iicopy(mat_ptr(3),
     >     fivep_offsets(1,first_off),2*ndia)

      return
      end
C----------------------------------------------------------------
      subroutine get_dia_offset(i_off,j_off,mat_ptr,diag)

C     Arguments
C----
      integer i_off,j_off,mat_ptr(*),diag

      i_off = mat_ptr(3+2*(diag-1))
      j_off = mat_ptr(3+2*diag-1)

      return
      end
C----------------------------------------------------------------
      function compute_nnzero_grid(mat_ptr,vec_inf)

C     Arguments
C----
      integer mat_ptr(*),vec_inf(*),compute_nnzero_grid

      compute_nnzero_grid = 
     >     (mat_ptr(2)+1)*vec_inf(2)

      return
      end
C----------------------------------------------------------------
C     Dump orthogonally stored matrix;
C----------------------------------------------------------------
      subroutine dump_matx_grid(matrix,mat_ptr,vec_inf)
      
C     Arguments
C---- 
      integer mat_ptr(*),vec_inf(*)
      double precision matrix(*)
      
C     Local
C----
      integer dia,loc,iof,jof
      character*10 numbers
      character*13 dia_string
      data dia_string,numbers/'diag-<  ,  >$','0123456789'/

      call pd1i('matrix at$',1)
      call dump_vector_o(matrix(1),vec_inf, 'matdia$',0)

      do 10 dia=1,mat_ptr(2)
         loc = dia*vec_inf(2)+1
         call get_dia_offset(iof,jof,mat_ptr,dia)
         call pd1i1i('Off diag$',dia,' at$',loc)
         call pd2i('-- offsets$',iof,jof)
         if (iof.lt.0) then
            dia_string(7:7) = '-'
            iof = -iof
         else
            dia_string(7:7) = '+'
         endif
         dia_string(8:8) = numbers(iof+1:iof+1)
         if (jof.lt.0) then
            dia_string(10:10) = '-'
            jof = -jof
         else
            dia_string(10:10) = '+'
         endif
         dia_string(11:11) = numbers(jof+1:jof+1)
         call dump_vector_o(matrix(loc), vec_inf, dia_string,0)
 10   continue
      
      return
      end
C----------------------------------------------------------------
C     Dump a 2D vector to the dump channel
C----------------------------------------------------------------
      subroutine dump_vector_g(x,i0,i1,j0,j1, vec_inf,
     >     ibeg,iend,jbeg,jend, txt,itxt)

C     Arguments
C---- 
      integer i0,i1,j0,j1,ibeg,iend,jbeg,jend, itxt,vec_inf(*)
      character*(*) txt
      double precision x(i0:i1,j0:j1)

C     Local
C----
      integer row,col

C     Dump the internal part of the vector
C----
      call pd1iai('Dump vector; origin @$',vec_inf(6),
     >     'loc:$',vec_inf(vec_inf(6)),2)
      do 10 col=jbeg,jend
         do 20 row=ibeg,iend
            call pdi2id(txt,itxt,
     >           'i,j:$',
     >           vec_inf(vec_inf(6))+row-1,
     >           vec_inf(vec_inf(6)+1)+col-1,
     >           'val:$',x(row,col))
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Dump the border of a 2D vector
C----------------------------------------------------------------
      subroutine dump_border_g(x,i0,i1,j0,j1,vec_inf,
     >     ibeg,iend,jbeg,jend, txt,itxt)

C     Arguments
C---- 
      integer i0,i1,j0,j1,ibeg,iend,jbeg,jend, itxt,vec_inf(*)
      character*(*) txt
      double precision x(i0:i1,j0:j1)

C     Local
C----
      integer row,col, trow,tcol,
     >     grid_lo(4),grid_hi(4),global_grid_hi(4)
      character*20 b_txt

      b_txt(1:2) = 'b_'
      col = index(txt,'$')
      b_txt(3:2+col) = txt(1:col)
      call iicopy(grid_lo,vec_inf(vec_inf(6)),
     >     vec_inf(vec_inf(5)+1))
      call iicopy(grid_hi,
     >     vec_inf(vec_inf(6)+vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(5)+1))
      call iicopy(global_grid_hi,
     >     vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(5)+1))

C     Dump the four borders
C----
      do 11 col=j0,jbeg-1
         tcol = grid_lo(2)+col-1
         if (tcol.lt.1 .or. tcol.gt.global_grid_hi(2)) goto 13
         do 12 row=i0,i1
            trow = grid_lo(1)+row-1
            if (trow.lt.1 .or. trow.gt.global_grid_hi(1)) goto 14
            call pdi2id(b_txt,itxt,
     >           'i,j:$',trow,tcol,'val:$',x(row,col))
 14         continue
 12      continue
 13      continue
 11   continue
      do 21 col=jend+1,j1
         tcol = grid_lo(2)+col-1
         if (tcol.lt.1 .or. tcol.gt.global_grid_hi(2)) goto 23
         do 22 row=i0,i1
            trow = grid_lo(1)+row-1
            if (trow.lt.1 .or. trow.gt.global_grid_hi(1)) goto 24
            call pdi2id(b_txt,itxt,
     >           'i,j:$',trow,tcol,'val:$',x(row,col))
 24         continue
 22      continue
 23      continue
 21   continue
      do 31 row=i0,ibeg-1
         trow = grid_lo(1)+row-1
         if (trow.lt.1 .or. trow.gt.global_grid_hi(1)) goto 33
         do 32 col=j0,j1
            tcol = grid_lo(2)+col-1
            if (tcol.lt.1 .or. tcol.gt.global_grid_hi(2)) goto 34
            call pdi2id(b_txt,itxt,
     >           'i,j:$',trow,tcol,'val:$',x(row,col))
 34         continue
 32      continue
 33      continue
 31   continue
      do 41 row=iend+1,i1
         trow = grid_lo(1)+row-1
         if (trow.lt.1 .or. trow.gt.global_grid_hi(1)) goto 43
         do 42 col=j0,j1
            tcol = grid_lo(2)+col-1
            if (tcol.lt.1 .or. tcol.gt.global_grid_hi(2)) goto 44
            call pdi2id(b_txt,itxt,
     >           'i,j:$',trow,tcol,'val:$',x(row,col))
 44         continue
 42      continue
 43      continue
 41   continue

      return
      end
