************************************************************************
************************************************************************
***** HBTC ..... GET MATRIX FROM HARWELL-BOEING COLLECTION     *****
************************************************************************
************************************************************************
*     
*     PURPOSE:
*     THIS SUBROUTINE READS IN A MATRIX PROBLEM FROM A FILE IN THE
*     HARWELL-BOEING TEST COLLECTION.  THE MATRIX IS REPRESENTED
*     COLUMN BY COLUMN.  NOTE THAT ONLY THE COEFFICIENT MATRIX IS
*     EXTRACTED; ANY RIGHT HAND SIDES OR INITIAL GUESSES ARE IGNORED.
*     
*     Modified 11/1/92 to return data set type information. 
*     Modified 11/1/92 to call LSAME to do character compares.
*     
*     INPUT PARAMETERS:
*     (I) INPUT       -   INPUT UNIT.
*     (I) LENPTR      -   LENGTH OF POINTR (SEE BELOW).
*     (I) LENIDX      -   LENGTH OF ROWIND (SEE BELOW).
*     (I) LENV        -   LENGTH OF VALUES (SEE BELOW).
*     
*     OUTPUT PARAMETERS:
*     (I) MTYPE       -   MATRIX TYPE.
*     MTYPE = 0: ASSEMBLED MATRIX.
*     MTYPE = 1: ELEMENTAL MATRICES.
*     (L) NUMVAL      -   TRUE IF NUMERICAL VALUES ARE AVAILABLE;
*     FALSE OTHERWISE.
*     (I) NROWS       -   NUMBER OF ROWS (OR VARIABLES).
*     (I) NCOLS       -   NUMBER OF COLUMNS (FOR MTYPE = 0) OR
*     ELEMENTS (FOR MTYPE = 1).
*     (I) NNZERO      -   NUMBER OF ROW INDICES (FOR MTYPE = 0).
*     (I) NELTVL      -   NUMBER OF ELEMENTS (FOR MTYPE = 1).
*     (I) POINTR(*)   -   ARRAY OF LENGTH NCOLS+1 THAT THAT HOLDS
*     POINTERS TO SUBSCRIPTS.
*     (I) ROWIND(*)   -   ARRAY OF LENGTH POINTR(NCOLS+1)-1 THAT
*     HOLDS THE ROW SUBSCRIPTS.
*     (R) VALUES(*)   -   ARRAY THAT HOLDS THE NUMERICAL VALUES.
*     ITS LENGTH DEPENDS ON THE VALUE OF MTYPE.
*     (I) IFLAG       -   ERROR FLAG.
*     IFLAG =  0: NO ERROR.
*     IFLAG =  1: INSUFFICIENT SPACE FOR POINTERS.
*     IFLAG =  2: INSUFFICIENT SPACE FOR
*     SUBSCRIPTS.
*     IFLAG =  3: INSUFFICIENT SPACE FOR
*     NUMERICAL VALUES.
*     IFLAG =  4: ERROR IN READING INPUT FILE.
*     IFLAG = -1: END OF FILE HAS BEEN REACHED.
*     (C3) CTYPE       -   Type information:
*     First Character:        r       Real Matrix
*     c       Complex Matrix
*     p       Pattern Only (no values supplied)
*     
*     Second Character:       s       Symmetric
*     u       Unsymmetric
*     h       Hermitian
*     z       Skew symmetric
*     r       Rectangular
*     
*     Third Character:        a       Assembled
*     f       Unassembled Finite Elements
*     
*     Local junk:
*     (C) STRING      -   TITLE OF MATRIX PROBLEM (AT LEAST 80
*     CHARACTERS LONG).
*     
************************************************************************
C----------------------------------------------------------------
      SUBROUTINE demo_get_harbo_info
     >     (INPUT, MTYPE, NUMVAL, HB_info_buffer, private, IFLAG)
      
      CHARACTER           STRING*81
      INTEGER             IFLAG, INPUT, NUMVAL, HB_info_buffer(*),
     &     MTYPE, private
      
C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Local variables
C----
      INTEGER INDCRD, PTRCRD, RHSCRD(1),
     >     NROWS,NCOLS, NNZERO,
     &     TOTCRD, VALCRD(1)
      LOGICAL             LSAME,tio,trace_fileio,i_in,a_in,bcst
      character*30 fmt1,fmt2

C     Two common blocks to carry info from this routine to
C     the next. Not terribly important
C----
      integer NELTVL, NRHSIX, NRHS
      common /hbnums/NELTVL, NRHSIX, NRHS

      CHARACTER CTYPE*3,
     >     RHSTYP*3, INDFMT*16, PTRFMT*16, RHSFMT*20, VALFMT*20
      common /hbtypeb/ctype,rhstyp,indfmt,ptrfmt,rhsfmt,valfmt
     
************************************************************************
     
      IFLAG = 0
      tio = trace_fileio()
      i_in = .true.
      a_in = .false.
      bcst = .false.
*     
      NRHS = 0
      NRHSIX = 0
*     -------------------------
*     ... READ IN HEADER BLOCK.
*     -------------------------
      if (i_in) then
         READ (INPUT,11,END=200,ERR=101)  STRING
 11      FORMAT ( A80 )
         if (log_channel_open) write(logchn,*) string
         string(81:81) = '$'
         if (tio) call pd0(string)
      endif

C     Second line: numbers of cards
C----
      if (i_in) READ (INPUT,22,END=102,ERR=103)
     &     TOTCRD, PTRCRD, INDCRD, VALCRD(1), RHSCRD(1)
 22   FORMAT ( 5I14 )
      if (bcst) then
         call inspread(VALCRD,1,'HB info VALCRD$')
         call inspread(RHSCRD,1,'HB info RHSCRD$')
      endif
      if (tio) call pd2i('Harbo size2$',VALCRD(1), RHSCRD(1))


C     Third line: numbers of rows column nonzeros
C----
      if (i_in) READ (INPUT,33,END=104,ERR=105)
     &     CTYPE, NROWS, NCOLS, NNZERO, NELTVL
 33   FORMAT ( A3, 11X, 4I14 )
      if (tio) call pd4i('Harbo size3$',NROWS, NCOLS, NNZERO, NELTVL)
      hb_info_buffer(1) = NROWS
      hb_info_buffer(2) = NCOLS
      hb_info_buffer(3) = NNZERO
      hb_info_buffer(4) = NELTVL
      if (bcst) then
         call txspread(CTYPE,3,'HB info CTYPE$')
         call inspread(HB_info_buffer,4,'HB info$')
      endif

C     Fourth line: formats; these don't have to be broadcast
C----
      if (i_in) then
         READ (INPUT,44,END=106,ERR=107)
     &        PTRFMT, INDFMT, VALFMT, RHSFMT
         fmt1 = 'Read fmt: <                > $'
         fmt1(12:28) = ptrfmt
         fmt2 = 'also fmt: <                > $'
         fmt2(12:28) = indfmt
         if (tio) call pd00(fmt1,fmt2)
         fmt1 = 'Also: <                    > $'
         fmt1(8:28) = valfmt
         fmt2 = 'also: <                    > $'
         fmt2(8:28) = rhsfmt
         if (tio) call pd00(fmt1,fmt2)
 44      FORMAT ( 2A16, 2A20 )
         IF  ( RHSCRD(1) .GT. 0 )  THEN
            READ (INPUT,55,END=108,ERR=109)  RHSTYP, NRHS, NRHSIX
 55         FORMAT ( A3, 11X, 2I14 )
         ENDIF
      endif
*     
      IF  ( LSAME(CTYPE(3:3), 'A') )  THEN
         MTYPE = 0
      ELSE
         MTYPE = 1
      ENDIF
c$$$      IF  ( VALCRD(1) .NE. 0 )  THEN
c$$$         NUMVAL = .TRUE.
c$$$      ELSE
c$$$         NUMVAL = .FALSE.
c$$$      ENDIF
      numval = VALCRD(1)

      return
      
*     ----------------------------
*     ERRORs IN READING INPUT FILE.
*     ----------------------------
 101  iflag = 1
      return
 102  iflag = 2
      return
 103  iflag = 3
      return
 104  iflag = 4
      return
 105  iflag = 5
      return
 106  iflag = 6
      return
 107  iflag = 7
      return
 108  iflag = 8
      return
 109  iflag = 9
      return
c      IFLAG = 4
*     
 200  CONTINUE
*     -----------------------------
*     END OF FILE HAS BEEN REACHED.
*     -----------------------------
      IFLAG = -1
      NROWS = 0
      NCOLS = 0
      NNZERO = 0
      NELTVL = 0
      RETURN
*     
      end
C----------------------------------------------------------------
      SUBROUTINE  harbo_matrix_from_file_inner
     >     (matrix,need_matrix, pointers,indexes, iv,
     >     VALUES,ROWIND,POINTR,
     >     INPUT, Nsize, NNZERO, LENPTR,LENIDX,LENV, IFLAG)
      
      
      double precision matrix(*),VALUES(*)
      integer pointers(*),indexes(*),iv(*),
     >     ROWIND(*), POINTR(*),
     >     IFLAG, INPUT , LENIDX,LENPTR,LENV, 
     >     nsize, NNZERO, need_matrix
      
C     Information inherited from the previous routine
C----
      CHARACTER CTYPE*3,
     >     RHSTYP*3, INDFMT*16, PTRFMT*16, RHSFMT*20, VALFMT*20
      common /hbtypeb/ctype,rhstyp,indfmt,ptrfmt,rhsfmt,valfmt
      
      integer NELTVL, NRHSIX, NRHS
      common /hbnums/NELTVL, NRHSIX, NRHS

C     Local
C---- 
      logical i_in,a_in, LSAME
      INTEGER I, ITEMP, NEXACT, NGUESS, NRHSVL,
     >     ncols,nrows, idum
      double precision    TEMP
      
C     Some convenient constants
C----
      nrows = nsize
      ncols = nsize
*     
*     --------------------------
*     ... READ MATRIX STRUCTURE.
*     --------------------------
      IF  ( NCOLS+1 .GT. LENPTR )  THEN
         IFLAG = 1
         return
      ELSE
         if (i_in) READ (INPUT,PTRFMT,END=103,ERR=104)
     >        (POINTR(I),I=1,NCOLS+1)
         if (.not.a_in) call inspread(pointr,ncols+1,'HB pointers$')
      ENDIF
      IF  ( NNZERO .GT. LENIDX )  THEN
         IFLAG = 2
         return
      ELSE
         if (i_in) READ (INPUT,INDFMT,END=107,ERR=108)
     >        (ROWIND(I),I=1,NNZERO)
         if (.not.a_in) call inspread(rowind,nnzero,'HB indices$')
      ENDIF
      
*     -----------------------
*     ... READ MATRIX VALUES.
*     -----------------------
      IF  ( LSAME(CTYPE(3:3), 'A') )  THEN
         IF  ( NNZERO .GT. LENV )  THEN
            IFLAG = 3
            return
         ELSE
            if (i_in) READ (INPUT,VALFMT,END=111,ERR=112)
     &           (VALUES(I),I=1,NNZERO)
            if (.not.a_in) call dpspread(values,nnzero,'HB values$')
         ENDIF
      ELSE
         IF  ( NELTVL .GT. LENV )  THEN
            IFLAG = 3
            READ (INPUT,VALFMT,END=113,ERR=114) (TEMP,I=1,NELTVL)
         ELSE
            READ (INPUT,VALFMT,END=115,ERR=116)
     &           (VALUES(I),I=1,NELTVL)
         ENDIF
      ENDIF

*     -----------------------------------
*     ... READ AND SKIP RIGHT-HAND SIDES.
*     -----------------------------------
*     
      IF  ( NRHS .GT. 0 )  THEN
*     
         IF  ( LSAME(RHSTYP(1:1), 'F') )  THEN
*     --------------------------------
*     ... READ DENSE RIGHT-HAND SIDES.
*     --------------------------------
            NRHSVL = NROWS*NRHS
            READ (INPUT,RHSFMT,END=117,ERR=117)
     &           (TEMP,I=1,NRHSVL)
         ELSE
*     ----------------------------------------------
*     ... READ SPARSE OR ELEMENTAL RIGHT-HAND SIDES.
*     ----------------------------------------------
            IF  ( LSAME(CTYPE(3:3), 'A') )  THEN
*     ---------------------------------
*     ... READ SPARSE RIGHT-HAND SIDES.
*     ---------------------------------
*     
*     --------------------------------------------
*     ... READ POINTER ARRAY FOR RIGHT-HAND SIDES.
*     --------------------------------------------
               READ (INPUT,PTRFMT,END=117,ERR=117)
     &              (ITEMP,I=1,NRHS+1)
*     ----------------------------------------
*     ... READ SPARSITY PATTERN FOR RIGHT-HAND
*     SIDES.
*     ----------------------------------------
               READ (INPUT,INDFMT,END=117,ERR=117)
     &              (ITEMP,I=1,NRHSIX)
*     ---------------------------------------
*     ... READ SPARSE RIGHT-HAND SIDE VALUES.
*     ---------------------------------------
               READ (INPUT,RHSFMT,END=117,ERR=117)
     &              (TEMP,I=1,NRHSIX)
            ELSE
*     ------------------------------------
*     ... READ ELEMENTAL RIGHT-HAND SIDES.
*     ------------------------------------
               NRHSVL = NNZERO*NRHS
               READ (INPUT,RHSFMT,END=117,ERR=117)
     &              (TEMP,I=1,NRHSVL)
            ENDIF
         ENDIF
         IF  ( LSAME(RHSTYP(2:2),'G') )  THEN
*     --------------------------
*     ... READ STARTING GUESSES.
*     --------------------------
            NGUESS = NROWS*NRHS
            READ (INPUT,RHSFMT,END=117,ERR=117)
     &           (TEMP,I=1,NGUESS)
         ENDIF
         IF  ( LSAME(RHSTYP(3:3), 'X' ))  THEN
*     --------------------------
*     ... READ SOLUTION VECTORS.
*     --------------------------
            NEXACT = NROWS*NRHS
            READ (INPUT,RHSFMT,END=117,ERR=117)
     &           (TEMP,I=1,NEXACT)
         ENDIF
      ENDIF
      RETURN
*     
 100  CONTINUE
*     ----------------------------
*     ERRORs IN READING INPUT FILE.
*     ----------------------------
 101  iflag = 1
      return
 102  iflag = 2
      return
 103  iflag = 3
      return
 104  iflag = 4
      return
 105  iflag = 5
      return
 106  iflag = 6
      return
 107  iflag = 7
      return
 108  iflag = 8
      return
 109  iflag = 9
      return
 110  iflag = 10
      return
 111  iflag = 11
      return
 112  iflag = 12
      return
 113  iflag = 13
      return
 114  iflag = 14
      return
 115  iflag = 15
      return
 116  iflag = 16
      return
 117  iflag = 17
      return
c      IFLAG = 4
*     
      END
