C     Main program for matrix generation utility
C----
      program quasi_harwell_generation

C     Arrays
C----
      integer maxvar,vec, need,
     >    leng_vec_inf,leng_mat_ptr,leng_mat_idx,
     >    ibuf_len,rbuf_len
      parameter (maxvar=50 000,leng_vec_inf=100,leng_mat_ptr=100,
     >     leng_mat_idx=20,ibuf_len=20,rbuf_len=20)
      integer leng_demo,vec_inf(leng_vec_inf),
     >     mat_ptr(leng_mat_ptr),mat_idx(leng_mat_idx),
     >     comm_context(100)
      parameter (leng_demo=6*maxvar)
      double precision demo(leng_demo)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
C     The problem format.
C----
      integer         sparsity,part_scheme
      common /prbfmt/ sparsity,part_scheme

C     Functions
C---- 
      integer vector_size

      call reset_allocation(demo,1,leng_demo)
      dmpchn = 6
      dmp_channel_open = .true.

      call trace_initializations

      call pt0('>> Problem format$')
      call problem_initializations(vec_inf,comm_context)

      call pt0('>> Generating pde$')
      call pde_initialization(comm_context)

      call matrix_creation(demo,need,
     >     mat_ptr,leng_mat_ptr, mat_idx,leng_mat_idx,
     >     vec_inf,leng_vec_inf)
      call force_range(need,1,leng_demo,
     >     'Demo matrix overflow$')

      vec = vector_size(vec_inf)
      call force_range(vec,1,maxvar,
     >     'Vector size prior to dump$')
      call pt1i('>> Dumping matrix; size=$',
     >     vec_inf(vec_inf(5)+2)*vec_inf(vec_inf(5)+2+1))

      call setup_file(blkchn,
     >     '../input.data/',14,
     >     'mat.dat',7,'Dump matrix name$')
      if (10*(vec_inf(1)/10).eq.10) then
         write(blkchn,99) 'fsh'
      else if (10*(vec_inf(1)/10).eq.20) then
         write(blkchn,99) 'dia'
      else if (10*(vec_inf(1)/10).eq.30) then
         write(blkchn,99) 'hbf'
      else
         write(6,*) 'Unknown problem fmt:',vec_inf(1)
         stop
      endif
 99   format(a3)
      close(blkchn)


      if (10*(vec_inf(1)/10).eq.10) then
         call setup_file(blkchn,
     >        '../input.data/',14,
     >        'fsh.mat',7,'Dump matrix name$')
         call grid_dump(
     >        demo(1),
     >        demo(1+vec_inf(2)),mat_ptr(2),
     >        mod(vec_inf(1),2).eq.1,
     >        mat_ptr,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),
     >        blkchn)
      else if (10*(vec_inf(1)/10).eq.20) then
         call setup_file(blkchn,
     >        '../input.data/',14,
     >        'dia.mat',7,'Dump matrix name$')
         call diag_dump(
     >        demo(1),
     >        demo(1+vec_inf(2)),mat_ptr(2),mat_ptr,
     >        mod(vec_inf(1),2).eq.1,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),
     >        blkchn)
      else if (10*(vec_inf(1)/10).eq.30) then
         call setup_file(blkchn,
     >        '../input.data/',14,
     >        'hbf.mat',7,'Dump matrix name$')
         call harbo_dump(
     >        demo(1),
     >        demo(1+vec_inf(2)),mat_ptr(2),mat_ptr,
     >        mod(vec_inf(1),2).eq.1,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),
     >        blkchn)
      else
         write(6,*) 'Unknown problem fmt:',vec_inf(1)
         stop
      endif
      close(blkchn)

      end
C----------------------------------------------------------------
      block data lcomat

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      data pgrid_dimension,pgrid_size
     >     /2,1,1,0,0/

      end
C----------------------------------------------------------------
      subroutine grid_dump(d,offs,noff,cs,
     >     mat_ptr,ipts,jpts,bord, chan)
      
C     Arguments
C---- 
      integer ipts,jpts,bord, mat_ptr(*),noff, chan
      double precision 
     >     d(ipts,jpts),offs(ipts,jpts,*)
      logical cs
      
C     Local
C---- 
      integer col, cnt, ioff,i_of,j_of

      if (cs) then
         call pt0('>>> Dumping symmetric 2D grid matrix$')
      else
         call pt0('>>> Dumping 2D grid matrix$')
      endif

      write(chan,*) ipts,jpts
      do 30 col=1,jpts
         write(chan,*) (d(cnt,col),cnt=1,ipts)
 30   continue

      do 10 ioff=1,noff
         call get_dia_offset(i_of,j_of,mat_ptr,ioff)
         if (.not.cs .or.
     >        (cs.and.(j_of.gt.0.or.(j_of.eq.0.and.i_of.gt.0)))) then
            write(chan,*) i_of,j_of
            do 31 col=1,jpts
               write(chan,*) (offs(cnt,col,ioff),cnt=1,ipts)
 31         continue
         endif
 10   continue

      call pt0('>> Matrix written<<$')
         
      return
      end
C----------------------------------------------------------------
      subroutine diag_dump(d,offs,noff, mat_ptr,
     >     cs,ipts,jpts,bord, chan)
      
C     Arguments
C---- 
      integer ipts,jpts,bord, mat_ptr(*),noff, chan
      double precision 
     >     d(ipts,jpts),
     >     offs(ipts,jpts,*)
      logical cs

C     The problem format.
C----
      integer         sparsity,part_scheme
      common /prbfmt/ sparsity,part_scheme

C     Local
C---- 
      integer col, cnt, ioff,i_of,j_of,v_of,woff

      if (cs) then
         call pt0('>>> Dumping symmetric diagonal storage matrix$')
      else
         call pt0('>>> Dumping diagonal storage matrix$')
      endif

      if (cs) then
         woff = 0
         do 20 ioff=noff,1,-1
            call get_dia_offset(i_of,j_of,mat_ptr,ioff)
            v_of = j_of*ipts + i_of
            if (v_of.gt.0) woff = woff+1
 20      continue
      else
         woff = noff
      endif

      write(chan,*) ipts*jpts,woff+1
      write(chan,*) 0
      do 30 col=1,jpts
         write(chan,*) (d(cnt,col),cnt=1,ipts)
 30   continue

      do 10 ioff=noff,1,-1
         call get_dia_offset(i_of,j_of,mat_ptr,ioff)
         v_of = j_of*ipts + i_of
         if (.not.cs .or. (cs.and.v_of.gt.0)) then
            write(chan,*) v_of
            do 31 col=j_of,-1
               write(chan,*) (0,cnt=1,ipts)
 31         continue
            do 32 col=max(1,1-j_of),min(jpts,jpts-j_of)
               write(chan,*) (0,cnt=i_of,-1),
     >              (offs(cnt,col,ioff),
     >               cnt=max(1,1-i_of),min(ipts,ipts-i_of)),
     >              (0,cnt=1,i_of)
 32         continue
            do 33 col=1,j_of
               write(chan,*) (0,cnt=1,ipts)
 33         continue
         endif
 10   continue

      call pt0('>> Matrix written<<$')
         
      return
      end
C----------------------------------------------------------------
      subroutine simple_dump(d,ln,l1,u1,un, ipts,jpts,bord, chan)
      
C     Arguments
C---- 
      integer ipts,jpts,bord, chan
      double precision 
     >     d(ipts,jpts),
     >     l1(ipts,jpts),
     >     u1(ipts,jpts),
     >     ln(ipts,jpts),
     >     un(ipts,jpts)
      
C     Local
C---- 
      integer row,col, cnt, num,ro,cl, nv,cs(20 000)
      double precision vs(20 000)
      
      num(ro,cl) = cl+(ro-1)*jpts
      
         call pt0('>>> Dumping CRS matrix$')
         write(chan,*) ipts*jpts
         do 10 row=1,ipts
            do 20 col=1,jpts
               nv = 0
               if (row.gt.1) then
                  nv = nv+1
                  cs(nv) = num(row-1,col)
                  vs(nv) = ln(row,col)
               endif
               if (col.gt.1) then
                  nv = nv+1
                  cs(nv) = num(row,col-1)
                  vs(nv) = l1(row,col)
               endif
               nv = nv+1
               cs(nv) =  num(row,col)
               vs(nv) = d(row,col)
               if (col.lt.jpts) then
                  nv = nv+1
                  cs(nv) = num(row,col+1)
                  vs(nv) = u1(row,col)
               endif
               if (row.lt.ipts) then
                  nv = nv+1
                  cs(nv) = num(row+1,col)
                  vs(nv) = un(row,col)
               endif
               write(chan,11) num(row,col),nv,(vs(cnt),cnt=1,nv)
               write(chan,12) (cs(cnt),cnt=1,nv)
 11            format(2(1x,i5),/,100(1x,f12.5))
 12            format(100(1x,i5))
 20         continue
 10      continue
      call pt0('>> Matrix written<<$')
         
      return
      end
C----------------------------------------------------------------
      subroutine harbo_dump(d,offs,noff,mat_ptr,
     >     cs, ipts,jpts,bord, chan)
      
C     Arguments
C---- 
      integer ipts,jpts,bord, noff,mat_ptr(*), chan
      double precision 
     >     d(ipts,jpts),
     >     offs(ipts,jpts,*)
      logical cs
      
C     The problem format.
C----
      integer         sparsity,part_scheme
      common /prbfmt/ sparsity,part_scheme

C     Local
C---- 
      integer row,col,nzero, nelts, num, pline,iline,vline,
     >     idx(1 000 000),ptr(100 000),i_of,j_of,ioff
      double precision val(1 000 000)
      character*80 title

      do 100 num=1,80
         title(num:num) = ' '
 100  continue
      title(01:37) = 'Constant diagonal matrix. Ask Victor.'
      title(73:80) = 'vecg_hbf'
      write(chan,1) '1',title(01:72),title(73:80)
 1    format(a1,a72,a7)

      nzero = 0
      num = 0
      do 10 row=1,ipts
         do 20 col=1,jpts
            call inc_n_chek(num,100 000)
            ptr(num) = nzero+1
C     Diagonal element
            call inc_n_chek(nzero,1 000 000)
            idx(nzero) = num
            val(nzero) = d (row,col)
C     Loop over all connections (very inefficiently implemented)
            do 30 ioff=1,noff
               call get_dia_offset(i_of,j_of,mat_ptr,ioff)
C     Ignore all back connections if this is symmetric
               if (.not.cs .or. (cs.and.(j_of.gt.0.or.
     >              (j_of.eq.0.and.i_of.gt.0)))) then
C     If this connects to a valid point:
                  if (col+j_of.ge.1 .and. col+j_of.le.jpts .and.
     >                 row+i_of.ge.1 .and. row+i_of.le.ipts) then
                     call inc_n_chek(nzero,1 000 000)
                     idx(nzero) = num+i_of*jpts+j_of
                     val(nzero) = offs(row,col,ioff)
                  endif
               endif
 30         continue
            call irsort(idx(ptr(num)),val(ptr(num)),nzero+1-ptr(num))
 20      continue
 10   continue
      ptr(num+1) = nzero+1

      nelts = ipts*jpts
      pline = (nelts+1)/16
      if (mod(nelts+1,16).ne.0) pline = pline+1

      iline = nzero/16
      if (mod(nzero,16).ne.0) iline = iline+1

      vline = nzero/5
      if (mod(nzero,5).ne.0) vline = vline+1

      write(chan,2) pline+iline+vline,pline,iline,vline,0
 2    format(5i14)

      if (cs) then
         call pt0('>>> Dumping symmetric Harwell/Boeing matrix$')
         write(chan,3) 'rsa',nelts,nelts,nzero,0
      else
         call pt0('>>> Dumping nonsymm Harwell/Boeing matrix$')
         write(chan,3) 'rua',nelts,nelts,nzero,0
      endif
 3    format(a3,11x,4i14)

      write(chan,4) '(16i5)          ','(16i5)          ',
     >     '(5e 16.8)           '
 4    format(2a16,2a20)

      write(chan,5)  (ptr(col),col=1,nelts+1)
 5    format(16i5)
      write(chan,6) (idx(col),col=1,nzero)
 6    format(16i5)
      write(chan,7) (val(col),col=1,nzero)
 7    format(5e16.8)

      call pt0('>> Matrix written<<$')
         
      return
      end
C----------------------------------------------------------------
      subroutine inc_n_chek(var,max)

C     Arguments
C----
      integer var,max

      call force_range(var+1,1,max,'Bound exceeded$')
      var = var+1

      return
      end
C----------------------------------------------------------------
C     Sabotage!
C----------------------------------------------------------------
      subroutine dpsend(buf,siz,typ,tar,where,send,trace)

C     Argument
C----
      integer siz,typ,tar
      double precision buf(*)
      character*50 where
      logical send,trace

      return
      end
C----------------------------------------------------------------
      subroutine dprecv(buf,siz,typ,ori,where,receive,trace)

C     Argument
C----
      integer siz,typ,ori
      double precision buf(*)
      character*50 where
      logical receive,trace

      return
      end
C----------------------------------------------------------------
      subroutine inspread(buf,siz,where)
      integer buf(*),siz
      character where
      return
      end
C----------------------------------------------------------------
      subroutine dpspread(buf,siz,where)
      integer siz
      double precision buf(*)
      character where
      return
      end
C----------------------------------------------------------------
      subroutine txspread(cbuf,siz,where)
      integer siz
      character*50 cbuf
      character where
      return
      end
C----------------------------------------------------------------
      subroutine ingsum(i,j)
      integer i,j
      return
      end
C----------------------------------------------------------------
      subroutine endcon
      return
      end
C----------------------------------------------------------------
      function lc2glb(i,j)
      integer i,j, lc2glb
      lc2glb=1
      return
      end
C----------------------------------------------------------------
      function wn2glb(i,j)
      integer i,j, wn2glb
      wn2glb=1
      return
      end
C----------------------------------------------------------------
      function wn2loc(i,j)
      integer i,j, wn2loc
      wn2loc=1
      return
      end
C----------------------------------------------------------------
      function i_input()
      logical i_input
      i_input = .true.
      return
      end
C----------------------------------------------------------------
      function i_input_small()
      logical i_input_small
      i_input_small = .true.
      return
      end
C----------------------------------------------------------------
      function i_input_big()
      logical i_input_big
      i_input_big = .true.
      return
      end
C----------------------------------------------------------------
      function all_input()
      logical all_input
      all_input = .true.
      return
      end
C----------------------------------------------------------------
      subroutine distance_to_proc(d,s,o)
      integer d,s,o
      return
      end
C----------------------------------------------------------------
      subroutine processor_num2ijk(i,n)
      integer i,n
      return
      end
C----------------------------------------------------------------
      function neighbour_proc(i)
      integer neighbour_proc,i
      neighbour_proc = -1
      return
      end
C----------------------------------------------------------------
      subroutine stop_connections(where)
      character*85 where
      stop
      end
